/*
 * Decompiled with CFR 0.152.
 */
package cn.antcore.kafka.core;

import cn.antcore.kafka.ConsumerCallback;
import cn.antcore.kafka.SendCallback;
import cn.antcore.kafka.config.KafkaConfig;
import cn.antcore.kafka.core.AntConsumer;
import cn.antcore.kafka.core.AntKafka;
import cn.antcore.kafka.core.AntProducer;
import java.util.Map;

public class AntKafkaImpl<K, V>
implements AntKafka<K, V> {
    private final String topic;
    private final KafkaConfig config;

    public static <K, V> AntKafka<K, V> create(String topic) {
        return new AntKafkaImpl<K, V>(topic);
    }

    public static <K, V> AntKafka<K, V> create(String topic, String bootstrapService) {
        return new AntKafkaImpl<K, V>(topic, bootstrapService);
    }

    public static <K, V> AntKafka<K, V> create(String topic, KafkaConfig config) {
        return new AntKafkaImpl<K, V>(topic, config);
    }

    private AntKafkaImpl(String topic) {
        this.topic = topic;
        this.config = new KafkaConfig();
    }

    private AntKafkaImpl(String topic, String bootstrapService) {
        this.topic = topic;
        this.config = new KafkaConfig(bootstrapService);
    }

    private AntKafkaImpl(String topic, KafkaConfig config) {
        this.topic = topic;
        this.config = config;
    }

    @Override
    public void send(V v) {
        AntProducer.get((String)this.topic, (Map)this.config.getProducerConfig()).send(v, (SendCallback)new SendCallback.Empty());
    }

    @Override
    public void send(V v, SendCallback callback) {
        AntProducer.get((String)this.topic, (Map)this.config.getProducerConfig()).send(v, callback);
    }

    @Override
    public void send(K k, V v) {
        AntProducer.get((String)this.topic, (Map)this.config.getProducerConfig()).send(k, v, (SendCallback)new SendCallback.Empty());
    }

    @Override
    public void send(K k, V v, SendCallback callback) {
        AntProducer.get((String)this.topic, (Map)this.config.getProducerConfig()).send(k, v, callback);
    }

    @Override
    public void receive(String groupId, ConsumerCallback<K, V> callback) {
        new AntConsumer(this.topic, groupId, this.config.getConsumerConfig()).addCallback(callback);
    }
}

