/*
 * Decompiled with CFR 0.152.
 */
package cn.antcore.kafka.builder;

import cn.antcore.kafka.annotation.KafkaClient;
import cn.antcore.kafka.builder.ConsumerBuilder;
import java.util.HashMap;
import java.util.Map;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.aop.framework.Advised;
import org.springframework.aop.support.AopUtils;
import org.springframework.beans.factory.config.ConfigurableListableBeanFactory;
import org.springframework.core.annotation.AnnotationUtils;

public class KafkaBuilder {
    private static final Logger LOG = LoggerFactory.getLogger(KafkaBuilder.class);
    private static ConfigurableListableBeanFactory BEAN_FACTORY;
    private static Map<String, Object> CLIENTS;

    public static void createClient(ConfigurableListableBeanFactory beanFactory, String[] names) {
        BEAN_FACTORY = beanFactory;
        new KafkaBuilder(names);
    }

    private KafkaBuilder(String[] names) {
        if (names == null) {
            if (LOG.isInfoEnabled()) {
                LOG.info("KafkaClient is empty.");
            }
            return;
        }
        this.createClient(names);
    }

    private void createClient(String[] names) {
        for (String name : names) {
            if (CLIENTS.containsKey(name)) continue;
            Object target = BEAN_FACTORY.getBean(name);
            if (AopUtils.isAopProxy((Object)target)) {
                target = KafkaBuilder.getTargetObject(target);
            }
            KafkaClient client = (KafkaClient)AnnotationUtils.findAnnotation(target.getClass(), KafkaClient.class);
            ConsumerBuilder consumerBuilder = ConsumerBuilder.create(target, client.topic(), client.groupId(), client.bootstrapService(), client.config());
            CLIENTS.put(name, consumerBuilder.build());
        }
    }

    private static <T> T getTargetObject(Object candidate) {
        try {
            if (AopUtils.isAopProxy((Object)candidate) && candidate instanceof Advised) {
                return (T)((Advised)candidate).getTargetSource().getTarget();
            }
        }
        catch (Exception ex) {
            throw new IllegalStateException("Failed to unwrap proxied object", ex);
        }
        return (T)candidate;
    }

    static {
        CLIENTS = new HashMap<String, Object>();
    }
}

