/*
 * Decompiled with CFR 0.152.
 */
package cn.antcore.kafka.builder;

import cn.antcore.kafka.ConsumerCallback;
import cn.antcore.kafka.annotation.ClientFail;
import cn.antcore.kafka.annotation.ClientInit;
import cn.antcore.kafka.annotation.ClientReceive;
import cn.antcore.kafka.annotation.ClientSuccess;
import cn.antcore.kafka.entity.ReceiveResult;
import cn.antcore.kafka.utils.BeanUtils;
import java.lang.reflect.Method;

public class ConsumerCallbackImpl
implements ConsumerCallback {
    protected Object target;
    private Method[] methods;

    public ConsumerCallbackImpl(Object target) {
        this.target = target;
        this.methods = BeanUtils.getMethods(target.getClass());
    }

    public void onInit() {
        Method method = BeanUtils.getMethodByAnnotation(this.methods, ClientInit.class);
        if (method != null) {
            BeanUtils.invokeMethod(this.target, method);
        }
    }

    public void onReceive(ReceiveResult result) {
        Method method = BeanUtils.getMethodByAnnotation(this.methods, ClientReceive.class);
        if (method == null) {
            return;
        }
        if (BeanUtils.validParameterTypes(method, 1, result.getClass())) {
            BeanUtils.invokeMethod(this.target, method, result);
        } else {
            BeanUtils.invokeMethod(this.target, method);
        }
    }

    public void onSuccess(Object key, Object body) {
        Method method = BeanUtils.getMethodByAnnotation(this.methods, ClientSuccess.class);
        if (method == null) {
            return;
        }
        if (BeanUtils.validParameterTypes(method, 2, key.getClass(), body.getClass())) {
            BeanUtils.invokeMethod(this.target, method, key, body);
        } else if (BeanUtils.validParameterTypes(method, 1, body.getClass())) {
            BeanUtils.invokeMethod(this.target, method, body);
        } else {
            BeanUtils.invokeMethod(this.target, method);
        }
    }

    public void onFail(Exception e) {
        Method method = BeanUtils.getMethodByAnnotation(this.methods, ClientFail.class);
        if (method == null) {
            return;
        }
        if (BeanUtils.validParameterTypes(method, 1, e.getClass())) {
            BeanUtils.invokeMethod(this.target, method, e);
        } else {
            BeanUtils.invokeMethod(this.target, method);
        }
    }
}

