/*
 * Decompiled with CFR 0.152.
 */
package cn.antcore.kafka.builder;

import cn.antcore.kafka.ConsumerCallback;
import cn.antcore.kafka.builder.ConsumerCallbackImpl;
import cn.antcore.kafka.config.KafkaConfig;
import cn.antcore.kafka.core.AntConsumer;
import cn.antcore.kafka.utils.BeanUtils;
import java.util.Map;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ConsumerBuilder {
    private static final Logger LOG = LoggerFactory.getLogger(ConsumerBuilder.class);
    private final Object target;
    private final String topic;
    private final String groupId;
    private final KafkaConfig config;

    public static ConsumerBuilder create(Object target, String topic, String groupId, String bootstrapService, Class<? extends KafkaConfig> config) {
        try {
            return new ConsumerBuilder(target, topic, groupId, (KafkaConfig)BeanUtils.instantiateClass(config.getConstructor(String.class), (Object[])new Object[]{bootstrapService}));
        }
        catch (NoSuchMethodException e) {
            LOG.error("NoSuchMethodException", (Throwable)e);
            return new ConsumerBuilder(target, topic, groupId, (KafkaConfig)BeanUtils.instantiateClass(config));
        }
    }

    private ConsumerBuilder(Object target, String topic, String groupId, KafkaConfig config) {
        this.target = target;
        this.topic = topic;
        this.groupId = groupId;
        this.config = config;
    }

    public Object build() {
        ConsumerCallbackImpl callback = new ConsumerCallbackImpl(this.target);
        Map map = this.config.getConsumerConfig();
        new AntConsumer(this.topic, this.groupId, map).addCallback((ConsumerCallback)callback);
        return this.target;
    }
}

