package cn.antcore.kafka.utils;

import cn.antcore.kafka.builder.ConsumerBuilder;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.core.annotation.AnnotationUtils;

import java.lang.annotation.Annotation;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;

/**
 *
 */
public final class BeanUtils extends org.springframework.beans.BeanUtils {

    private static final Logger LOG = LoggerFactory.getLogger(BeanUtils.class);

    /**
     * 获取全部方法
     *
     * @param clazz Class
     * @return Method[]
     */
    public static Method[] getMethods(Class<?> clazz) {
        return clazz.getMethods();
    }

    /**
     * 获取指定注解的方法
     *
     * @param methods    全部方法
     * @param annotation 注解
     * @return 方法
     */
    public static Method getMethodByAnnotation(Method[] methods, Class<? extends Annotation> annotation) {
        if (methods == null) {
            return null;
        }
        for (Method method : methods) {
            if (AnnotationUtils.findAnnotation(method, annotation) != null) {
                return method;
            }
        }
        return null;
    }

    /**
     * 执行方法
     *
     * @param target 目标对象
     * @param method 方法
     * @return true执行成功
     */
    public static boolean invokeMethod(Object target, Method method) {
        return invokeMethod(target, method, new Object[0]);
    }

    /**
     * 执行方法
     *
     * @param target 目标对象
     * @param method 方法
     * @param args   参数
     * @return true执行成功
     */
    public static boolean invokeMethod(Object target, Method method, Object... args) {
        try {
            method.invoke(target, args);
            return true;
        } catch (IllegalAccessException e) {
            if (LOG.isErrorEnabled()) {
                LOG.error("IllegalAccessException", e);
            }
        } catch (InvocationTargetException e) {
            if (LOG.isErrorEnabled()) {
                LOG.error("InvocationTargetException", e);
            }
        }
        return false;
    }

    /**
     * 验证方法参数
     *
     * @param method 方法
     * @param length 参数长度
     * @param array  目标参数
     * @return trur 成功
     */
    public static boolean validParameterTypes(Method method, int length, Class<?>... array) {
        Class<?>[] parameterTypes = method.getParameterTypes();
        if (length != parameterTypes.length) {
            return false;
        }
        return true;
    }
}
