package cn.antcore.kafka.core;

import cn.antcore.kafka.ConsumerCallback;
import cn.antcore.kafka.SendCallback;
import cn.antcore.kafka.config.KafkaConfig;

/**
 * AntKafkaImpl
 * Created By Hong on 2018/8/22
 **/
public class AntKafkaImpl<K, V> implements AntKafka<K, V> {


    /**
     * 创建AntKafka
     *
     * @param topic topic
     * @param <K>   泛型K
     * @param <V>   泛型V
     * @return AntKafkaImpl
     */
    public static <K, V> AntKafka<K, V> create(String topic) {
        return new AntKafkaImpl<>(topic);
    }

    /**
     * 创建AntKafka
     *
     * @param topic            topic
     * @param bootstrapService Kafka服务器地址
     * @param <K>              泛型K
     * @param <V>              泛型V
     * @return AntKafkaImpl
     */
    public static <K, V> AntKafka<K, V> create(String topic, String bootstrapService) {
        return new AntKafkaImpl<>(topic, bootstrapService);
    }

    /**
     * 创建AntKafka
     *
     * @param topic  topic
     * @param config 配置
     * @param <K>    泛型K
     * @param <V>    泛型V
     * @return AntKafkaImpl
     */
    public static <K, V> AntKafka<K, V> create(String topic, KafkaConfig config) {
        return new AntKafkaImpl<>(topic, config);
    }

    private final String topic;
    private final KafkaConfig config;

    /**
     * 构造函数
     *
     * @param topic topic
     */
    private AntKafkaImpl(String topic) {
        this.topic = topic;
        this.config = new KafkaConfig();
    }

    /**
     * 构造函数
     *
     * @param topic            topic
     * @param bootstrapService bootstrapService
     */
    private AntKafkaImpl(String topic, String bootstrapService) {
        this.topic = topic;
        this.config = new KafkaConfig(bootstrapService);
    }

    /**
     * 构造函数
     *
     * @param topic  topic
     * @param config config
     */
    private AntKafkaImpl(String topic, KafkaConfig config) {
        this.topic = topic;
        this.config = config;
    }

    @Override
    public void send(V v) {
        AntProducer.get(topic, this.config.getProducerConfig())
                .send(v, new SendCallback.Empty());
    }

    @Override
    public void send(V v, SendCallback callback) {
        AntProducer.get(topic, this.config.getProducerConfig())
                .send(v, callback);
    }

    @Override
    public void send(K k, V v) {
        AntProducer.get(topic, this.config.getProducerConfig())
                .send(k, v, new SendCallback.Empty());
    }

    @Override
    public void send(K k, V v, SendCallback callback) {
        AntProducer.get(topic, this.config.getProducerConfig())
                .send(k, v, callback);
    }

    @Override
    public void receive(String groupId, ConsumerCallback<K, V> callback) {
        new AntConsumer<>(topic, groupId, this.config.getConsumerConfig())
                .addCallback(callback);
    }
}
