package cn.antcore.kafka.core;

import cn.antcore.kafka.config.KafkaConfig;

/**
 * Created By Hong on 2018/8/31
 **/
public class AntKafkaBuilder<K, V> {

    /**
     * 创建AntKafka
     *
     * @param topic topic
     * @param <K>   Key
     * @param <V>   Value
     * @return AntKafkaBuilder
     */
    public static <K, V> AntKafkaBuilder<K, V> create(String topic) {
        return new AntKafkaBuilder<>(topic);
    }

    /**
     * Kafka Topic
     */
    private String topic;
    /**
     * Kafka Config
     */
    private KafkaConfig config;

    /**
     * 构造函数
     *
     * @param topic topic
     */
    private AntKafkaBuilder(String topic) {
        this.topic = topic;
    }

    /**
     * 设置bootstrapService
     *
     * @param bootstrapService Kafka Services
     * @return AntKafkaBuilder
     */
    public AntKafkaBuilder<K, V> bootstrapService(String bootstrapService) {
        this.config = new KafkaConfig(bootstrapService);
        return this;
    }

    /**
     * 设置Config
     *
     * @param config KafkaConfig
     * @return AntKafkaBuilder
     */
    public AntKafkaBuilder<K, V> config(KafkaConfig config) {
        this.config = config;
        return this;
    }

    /**
     * 创建AntKafka
     * @return AntKafka
     */
    public AntKafka<K, V> build() {
        if (this.config == null) {
            this.config = new KafkaConfig();
        }
        return AntKafkaImpl.create(topic, config);
    }


}
