package cn.antcore.kafka.core;

import cn.antcore.kafka.ConsumerCallback;
import cn.antcore.kafka.SendCallback;

/**
 * Created By Hong on 2018/8/31
 **/
public interface AntKafka<K, V> {

    /**
     * 发送消息
     *
     * @param v Value
     */
    void send(V v);

    /**
     * 发送消息
     *
     * @param v        Value
     * @param callback 回调
     */
    void send(V v, SendCallback callback);

    /**
     * 发送消息
     *
     * @param k Key
     * @param v Value
     */
    void send(K k, V v);

    /**
     * 发送消息
     *
     * @param k        Key
     * @param v        Value
     * @param callback 回调
     */
    void send(K k, V v, SendCallback callback);

    /**
     * 接收消息
     *
     * @param groupId  groupId
     * @param callback 回调
     */
    void receive(String groupId, ConsumerCallback<K, V> callback);
}
