package cn.antcore.kafka.annotation;

import cn.antcore.kafka.config.KafkaConfig;
import org.springframework.core.annotation.AliasFor;
import org.springframework.stereotype.Component;

import java.lang.annotation.*;

/**
 * Kafka消费者
 * Created By Hong on 2018/8/21
 **/
@Target({ElementType.TYPE})
@Retention(RetentionPolicy.RUNTIME)
@Documented
@Inherited
@Component
public @interface KafkaClient {

    /**
     * 默认topic
     *
     * @return topic
     */
    @AliasFor("topic")
    String value() default "default";

    /**
     * 默认topic
     *
     * @return topic
     */
    @AliasFor("value")
    String topic() default "default";

    /**
     * GroupId
     *
     * @return groupId
     */
    String groupId() default "default";

    /**
     * Kafka服务地址，多个逗号隔开
     *
     * @return bootstrapService
     */
    String bootstrapService() default "127.0.0.1:9092";

    /**
     * Kafka配置
     *
     * @return KafkaConfig
     */
    Class<? extends KafkaConfig> config() default KafkaConfig.class;
}
