/*
 * Decompiled with CFR 0.152.
 */
package cn.anloo.tool.canal.util;

import com.alibaba.google.common.base.Enums;
import java.math.BigDecimal;
import java.nio.charset.StandardCharsets;
import java.text.ParseException;
import java.time.Instant;
import java.time.LocalDate;
import java.time.LocalDateTime;
import java.time.ZoneId;
import java.util.Date;
import org.apache.commons.lang.time.DateUtils;

public final class StringConvertUtil {
    private static String[] PARSE_PATTERNS = new String[]{"yyyy-MM-dd HH:mm:ss", "yyyy-MM-dd HH:mm:ss.SSS", "yyyy-MM-dd HH:mm", "yyyy-MM", "yyyy/MM/dd", "yyyy/MM/dd HH:mm:ss", "yyyy/MM/dd HH:mm", "yyyy/MM", "yyyy.MM.dd", "yyyy.MM.dd HH:mm:ss", "yyyy.MM.dd HH:mm", "yyyy.MM", "yyyy-MM-dd"};

    static Object convertType(Class type, String columnValue) {
        if (columnValue == null || columnValue.length() == 0) {
            return null;
        }
        if (type.equals(String.class)) {
            return columnValue;
        }
        if (type.equals(Integer.class)) {
            return Integer.parseInt(columnValue);
        }
        if (type.equals(Long.class)) {
            return Long.parseLong(columnValue);
        }
        if (type.equals(Boolean.class)) {
            return StringConvertUtil.convertToBoolean(columnValue);
        }
        if (type.equals(BigDecimal.class)) {
            return new BigDecimal(columnValue);
        }
        if (type.equals(Double.class)) {
            return Double.parseDouble(columnValue);
        }
        if (type.equals(Float.class)) {
            return Float.valueOf(Float.parseFloat(columnValue));
        }
        if (type.equals(Date.class)) {
            return StringConvertUtil.parseDate(columnValue);
        }
        if (type.equals(LocalDate.class)) {
            return StringConvertUtil.parseLocalDate(columnValue);
        }
        if (type.equals(LocalDateTime.class)) {
            return StringConvertUtil.parseLocalDateTime(columnValue);
        }
        if (type.equals(java.sql.Date.class)) {
            return StringConvertUtil.parseSqlDate(columnValue);
        }
        if (type.isArray()) {
            return columnValue.getBytes(StandardCharsets.ISO_8859_1);
        }
        return Enums.stringConverter((Class)type).convert((Object)columnValue);
    }

    private static Object parseLocalDateTime(String str) {
        if (str == null) {
            return null;
        }
        Instant instant = StringConvertUtil.parseDate(str).toInstant();
        return instant.atZone(ZoneId.systemDefault()).toLocalDateTime();
    }

    private static Object parseLocalDate(String str) {
        if (str == null) {
            return null;
        }
        Instant instant = StringConvertUtil.parseDate(str).toInstant();
        return instant.atZone(ZoneId.systemDefault()).toLocalDate();
    }

    private static Date parseDate(String str) {
        if (str == null) {
            return null;
        }
        try {
            return DateUtils.parseDate((String)str, (String[])PARSE_PATTERNS);
        }
        catch (ParseException var2) {
            return null;
        }
    }

    private static Date parseSqlDate(String str) {
        if (str == null) {
            return null;
        }
        try {
            Date date = DateUtils.parseDate((String)str, (String[])PARSE_PATTERNS);
            return new java.sql.Date(date.getTime());
        }
        catch (ParseException var2) {
            return null;
        }
    }

    private static boolean convertToBoolean(String value) {
        return "1".equalsIgnoreCase(value) || "true".equalsIgnoreCase(value);
    }

    private StringConvertUtil() {
        throw new UnsupportedOperationException("This is a utility class and cannot be instantiated");
    }
}

