/*
 * Decompiled with CFR 0.152.
 */
package cn.anloo.tool.canal.util;

import cn.anloo.tool.canal.annotation.CanalTable;
import cn.anloo.tool.canal.enums.TableNameEnum;
import cn.anloo.tool.canal.handler.EntryHandler;
import cn.anloo.tool.canal.util.GenericUtil;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;

public class HandlerUtil {
    public static EntryHandler getEntryHandler(List<? extends EntryHandler> entryHandlers, String tableName) {
        EntryHandler globalHandler = null;
        for (EntryHandler entryHandler : entryHandlers) {
            String canalTableName = HandlerUtil.getCanalTableName(entryHandler);
            if (TableNameEnum.ALL.name().toLowerCase().equals(canalTableName)) {
                globalHandler = entryHandler;
                continue;
            }
            if (tableName.equals(canalTableName)) {
                return entryHandler;
            }
            String name = GenericUtil.getTableGenericProperties(entryHandler);
            if (name == null || !name.equals(tableName)) continue;
            return entryHandler;
        }
        return globalHandler;
    }

    public static Map<String, EntryHandler> getTableHandlerMap(List<? extends EntryHandler> entryHandlers) {
        ConcurrentHashMap<String, EntryHandler> map = new ConcurrentHashMap<String, EntryHandler>();
        if (entryHandlers != null && entryHandlers.size() > 0) {
            for (EntryHandler entryHandler : entryHandlers) {
                String canalTableName = HandlerUtil.getCanalTableName(entryHandler);
                if (canalTableName != null) {
                    map.putIfAbsent(canalTableName.toLowerCase(), entryHandler);
                    continue;
                }
                String name = GenericUtil.getTableGenericProperties(entryHandler);
                if (name == null) continue;
                map.putIfAbsent(name.toLowerCase(), entryHandler);
            }
        }
        return map;
    }

    public static EntryHandler getEntryHandler(Map<String, EntryHandler> map, String tableName) {
        EntryHandler entryHandler = map.get(tableName);
        if (entryHandler == null) {
            return map.get(TableNameEnum.ALL.name().toLowerCase());
        }
        return entryHandler;
    }

    public static String getCanalTableName(EntryHandler entryHandler) {
        CanalTable canalTable = entryHandler.getClass().getAnnotation(CanalTable.class);
        if (canalTable != null) {
            return canalTable.value();
        }
        return null;
    }
}

