/*
 * Decompiled with CFR 0.152.
 */
package cn.anloo.tool.canal.util;

import cn.anloo.tool.canal.handler.EntryHandler;
import java.lang.reflect.ParameterizedType;
import java.lang.reflect.Type;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import javax.persistence.Table;

public class GenericUtil {
    private static Map<Class<? extends EntryHandler>, Class> cache = new ConcurrentHashMap<Class<? extends EntryHandler>, Class>();

    static String getTableGenericProperties(EntryHandler entryHandler) {
        Table annotation;
        Class tableClass = GenericUtil.getTableClass(entryHandler);
        if (tableClass != null && (annotation = tableClass.getAnnotation(Table.class)) != null) {
            return annotation.name();
        }
        return null;
    }

    public static <T> Class<T> getTableClass(EntryHandler object) {
        Class<?> handlerClass = object.getClass();
        Class tableClass = cache.get(handlerClass);
        if (tableClass == null) {
            Type[] interfacesTypes;
            for (Type t : interfacesTypes = handlerClass.getGenericInterfaces()) {
                Class c = (Class)((ParameterizedType)t).getRawType();
                if (!c.equals(EntryHandler.class)) continue;
                tableClass = (Class)((ParameterizedType)t).getActualTypeArguments()[0];
                cache.putIfAbsent(handlerClass, tableClass);
                return tableClass;
            }
        }
        return tableClass;
    }
}

