/*
 * Decompiled with CFR 0.152.
 */
package cn.anloo.tool.canal.util;

import com.google.common.base.CaseFormat;
import java.lang.reflect.Field;
import java.lang.reflect.Modifier;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.stream.Collectors;
import javax.persistence.Column;
import javax.persistence.Transient;
import org.apache.commons.lang3.reflect.FieldUtils;

public class EntryUtil {
    private static Map<Class, Map<String, String>> cache = new ConcurrentHashMap<Class, Map<String, String>>();

    public static Map<String, String> getFieldName(Class c) {
        Map<String, String> map = cache.get(c);
        if (map == null) {
            List fields = FieldUtils.getAllFieldsList((Class)c);
            map = fields.stream().filter(EntryUtil::notTransient).filter(field -> !Modifier.isStatic(field.getModifiers())).collect(Collectors.toMap(EntryUtil::getColumnName, Field::getName));
            cache.putIfAbsent(c, map);
        }
        return map;
    }

    private static String getColumnName(Field field) {
        Column annotation = field.getAnnotation(Column.class);
        return annotation != null ? annotation.name() : CaseFormat.LOWER_CAMEL.to(CaseFormat.LOWER_UNDERSCORE, field.getName());
    }

    private static boolean notTransient(Field field) {
        Transient annotation = field.getAnnotation(Transient.class);
        return annotation == null;
    }
}

