/*
 * Decompiled with CFR 0.152.
 */
package cn.anloo.tool.canal.handler.impl;

import cn.anloo.tool.canal.factory.IModelFactory;
import cn.anloo.tool.canal.handler.EntryHandler;
import cn.anloo.tool.canal.handler.RowDataHandler;
import com.alibaba.otter.canal.protocol.CanalEntry;
import java.util.List;
import java.util.Map;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class MapRowDataHandlerImpl
implements RowDataHandler<List<Map<String, String>>> {
    private static final Logger log = LoggerFactory.getLogger(MapRowDataHandlerImpl.class);
    private IModelFactory<Map<String, String>> modelFactory;

    public MapRowDataHandlerImpl(IModelFactory<Map<String, String>> modelFactory) {
        this.modelFactory = modelFactory;
    }

    @Override
    public <R> void handlerRowData(List<Map<String, String>> list, EntryHandler<R> entryHandler, CanalEntry.EventType eventType) throws Exception {
        if (entryHandler != null) {
            log.info("\u5904\u7406\u6d88\u606f {}", list);
            switch (eventType) {
                case INSERT: {
                    Object entry = this.modelFactory.newInstance(entryHandler, list.get(0));
                    entryHandler.insert(entry);
                    break;
                }
                case UPDATE: {
                    Object before = this.modelFactory.newInstance(entryHandler, list.get(1));
                    Object after = this.modelFactory.newInstance(entryHandler, list.get(0));
                    entryHandler.update(before, after);
                    break;
                }
                case DELETE: {
                    Object o = this.modelFactory.newInstance(entryHandler, list.get(0));
                    entryHandler.delete(o);
                    break;
                }
                default: {
                    log.info("\u672a\u77e5\u6d88\u606f\u7c7b\u578b {} \u4e0d\u5904\u7406 {}", (Object)eventType, list);
                }
            }
        }
    }
}

