/*
 * Decompiled with CFR 0.152.
 */
package cn.anloo.tool.canal.handler;

import cn.anloo.tool.canal.context.CanalContext;
import cn.anloo.tool.canal.handler.EntryHandler;
import cn.anloo.tool.canal.handler.MessageHandler;
import cn.anloo.tool.canal.handler.RowDataHandler;
import cn.anloo.tool.canal.model.CanalModel;
import cn.anloo.tool.canal.util.HandlerUtil;
import com.alibaba.otter.canal.protocol.CanalEntry;
import com.alibaba.otter.canal.protocol.FlatMessage;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class AbstractFlatMessageHandler
implements MessageHandler<FlatMessage> {
    private static final Logger log = LoggerFactory.getLogger(AbstractFlatMessageHandler.class);
    private Map<String, EntryHandler> tableHandlerMap;
    private RowDataHandler<List<Map<String, String>>> rowDataHandler;
    private Logger logger = LoggerFactory.getLogger(AbstractFlatMessageHandler.class);

    public AbstractFlatMessageHandler(List<? extends EntryHandler> entryHandlers, RowDataHandler<List<Map<String, String>>> rowDataHandler) {
        this.tableHandlerMap = HandlerUtil.getTableHandlerMap(entryHandlers);
        this.rowDataHandler = rowDataHandler;
    }

    @Override
    public void handleMessage(FlatMessage flatMessage) {
        log.info("\u89e3\u6790\u6d88\u606f {}", (Object)flatMessage);
        List data = flatMessage.getData();
        if (data != null && data.size() > 0) {
            for (int i = 0; i < data.size(); ++i) {
                List maps;
                CanalEntry.EventType eventType = CanalEntry.EventType.valueOf((String)flatMessage.getType());
                if (eventType.equals((Object)CanalEntry.EventType.UPDATE)) {
                    Map map = (Map)data.get(i);
                    Map oldMap = (Map)flatMessage.getOld().get(i);
                    maps = Stream.of(map, oldMap).collect(Collectors.toList());
                } else {
                    maps = Stream.of(data.get(i)).collect(Collectors.toList());
                }
                try {
                    EntryHandler entryHandler = HandlerUtil.getEntryHandler(this.tableHandlerMap, flatMessage.getTable());
                    log.info("\u6d88\u606f\u5904\u7406\u5668 {}", (Object)entryHandler);
                    if (entryHandler == null) continue;
                    CanalModel model = CanalModel.Builder.builder().id(flatMessage.getId()).table(flatMessage.getTable()).executeTime(flatMessage.getEs()).database(flatMessage.getDatabase()).createTime(flatMessage.getTs()).build();
                    CanalContext.setModel(model);
                    log.info("\u6d88\u606f\u53d1\u9001\u81f3\u884c\u5904\u7406 {} {}", maps, (Object)eventType);
                    this.rowDataHandler.handlerRowData(maps, entryHandler, eventType);
                    continue;
                }
                catch (Exception e) {
                    log.error("\u6d88\u606f\u5904\u7406\u5f02\u5e38 ", (Throwable)e);
                    throw new RuntimeException("parse event has an error , data:" + data.toString(), e);
                }
                finally {
                    CanalContext.removeModel();
                }
            }
        }
    }
}

