/*
 * Decompiled with CFR 0.152.
 */
package cn.anloo.tool.canal.factory;

import cn.anloo.tool.canal.enums.TableNameEnum;
import cn.anloo.tool.canal.factory.AbstractModelFactory;
import cn.anloo.tool.canal.handler.EntryHandler;
import cn.anloo.tool.canal.util.EntryUtil;
import cn.anloo.tool.canal.util.FieldUtil;
import cn.anloo.tool.canal.util.GenericUtil;
import cn.anloo.tool.canal.util.HandlerUtil;
import com.alibaba.otter.canal.protocol.CanalEntry;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import org.apache.commons.lang3.StringUtils;

public class EntryColumnModelFactory
extends AbstractModelFactory<List<CanalEntry.Column>> {
    @Override
    public <R> R newInstance(EntryHandler entryHandler, List<CanalEntry.Column> columns) throws Exception {
        String canalTableName = HandlerUtil.getCanalTableName(entryHandler);
        if (TableNameEnum.ALL.name().toLowerCase().equals(canalTableName)) {
            Map<String, String> map = columns.stream().collect(Collectors.toMap(CanalEntry.Column::getName, CanalEntry.Column::getValue));
            return (R)map;
        }
        Class tableClass = GenericUtil.getTableClass(entryHandler);
        if (tableClass != null) {
            return (R)this.newInstance(tableClass, columns);
        }
        return null;
    }

    @Override
    public <R> R newInstance(EntryHandler entryHandler, List<CanalEntry.Column> columns, Set<String> updateColumn) throws Exception {
        String canalTableName = HandlerUtil.getCanalTableName(entryHandler);
        if (TableNameEnum.ALL.name().toLowerCase().equals(canalTableName)) {
            Map<String, String> map = columns.stream().filter(column -> updateColumn.contains(column.getName())).collect(Collectors.toMap(CanalEntry.Column::getName, CanalEntry.Column::getValue));
            return (R)map;
        }
        Class tableClass = GenericUtil.getTableClass(entryHandler);
        if (tableClass != null) {
            Object r = tableClass.newInstance();
            Map<String, String> columnNames = EntryUtil.getFieldName(r.getClass());
            for (CanalEntry.Column column2 : columns) {
                String fieldName;
                if (!updateColumn.contains(column2.getName()) || !StringUtils.isNotEmpty((CharSequence)(fieldName = columnNames.get(column2.getName())))) continue;
                FieldUtil.setFieldValue(r, fieldName, column2.getValue());
            }
            return (R)r;
        }
        return null;
    }

    @Override
    <R> R newInstance(Class<R> c, List<CanalEntry.Column> columns) throws Exception {
        R object = c.newInstance();
        Map<String, String> columnNames = EntryUtil.getFieldName(object.getClass());
        for (CanalEntry.Column column : columns) {
            String fieldName = columnNames.get(column.getName());
            if (!StringUtils.isNotEmpty((CharSequence)fieldName)) continue;
            FieldUtil.setFieldValue(object, fieldName, column.getValue());
        }
        return object;
    }
}

