/*
 * Decompiled with CFR 0.152.
 */
package cn.anloo.tool.canal.config.autoconfigure;

import cn.anloo.tool.canal.client.SimpleCanalClient;
import cn.anloo.tool.canal.config.autoconfigure.ThreadPoolAutoConfiguration;
import cn.anloo.tool.canal.config.properties.CanalSimpleProperties;
import cn.anloo.tool.canal.factory.EntryColumnModelFactory;
import cn.anloo.tool.canal.handler.EntryHandler;
import cn.anloo.tool.canal.handler.MessageHandler;
import cn.anloo.tool.canal.handler.RowDataHandler;
import cn.anloo.tool.canal.handler.impl.AsyncMessageHandlerImpl;
import cn.anloo.tool.canal.handler.impl.RowDataHandlerImpl;
import cn.anloo.tool.canal.handler.impl.SyncMessageHandlerImpl;
import com.alibaba.otter.canal.protocol.CanalEntry;
import java.util.List;
import java.util.concurrent.ExecutorService;
import org.springframework.boot.autoconfigure.condition.ConditionalOnBean;
import org.springframework.boot.autoconfigure.condition.ConditionalOnProperty;
import org.springframework.boot.context.properties.EnableConfigurationProperties;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;
import org.springframework.context.annotation.Import;

@Configuration
@EnableConfigurationProperties(value={CanalSimpleProperties.class})
@ConditionalOnBean(value={EntryHandler.class})
@ConditionalOnProperty(value={"canal.mode"}, havingValue="simple", matchIfMissing=true)
@Import(value={ThreadPoolAutoConfiguration.class})
public class SimpleClientAutoConfiguration {
    private CanalSimpleProperties canalSimpleProperties;

    public SimpleClientAutoConfiguration(CanalSimpleProperties canalSimpleProperties) {
        this.canalSimpleProperties = canalSimpleProperties;
    }

    @Bean
    public RowDataHandler<CanalEntry.RowData> rowDataHandler() {
        return new RowDataHandlerImpl(new EntryColumnModelFactory());
    }

    @Bean
    @ConditionalOnProperty(value={"canal.async"}, havingValue="true", matchIfMissing=true)
    public MessageHandler messageHandler(RowDataHandler<CanalEntry.RowData> rowDataHandler, List<EntryHandler> entryHandlers, ExecutorService executorService) {
        return new AsyncMessageHandlerImpl(entryHandlers, rowDataHandler, executorService);
    }

    @Bean
    @ConditionalOnProperty(value={"canal.async"}, havingValue="false")
    public MessageHandler messageHandler(RowDataHandler<CanalEntry.RowData> rowDataHandler, List<EntryHandler> entryHandlers) {
        return new SyncMessageHandlerImpl(entryHandlers, rowDataHandler);
    }

    @Bean(initMethod="start", destroyMethod="stop")
    public SimpleCanalClient simpleCanalClient(MessageHandler messageHandler) {
        String server = this.canalSimpleProperties.getServer();
        String[] array = server.split(":");
        return SimpleCanalClient.builder().hostname(array[0]).port(Integer.parseInt(array[1])).destination(this.canalSimpleProperties.getDestination()).userName(this.canalSimpleProperties.getUserName()).password(this.canalSimpleProperties.getPassword()).messageHandler(messageHandler).batchSize(this.canalSimpleProperties.getBatchSize()).filter(this.canalSimpleProperties.getFilter()).timeout(this.canalSimpleProperties.getTimeout()).unit(this.canalSimpleProperties.getUnit()).build();
    }
}

