/*
 * Decompiled with CFR 0.152.
 */
package cn.anloo.tool.canal.client;

import cn.anloo.tool.canal.client.AbstractCanalClient;
import cn.anloo.tool.canal.handler.MessageHandler;
import com.alibaba.otter.canal.client.CanalConnector;
import com.alibaba.otter.canal.client.kafka.KafkaCanalConnector;
import com.alibaba.otter.canal.protocol.FlatMessage;
import java.util.List;
import java.util.concurrent.TimeUnit;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class KafkaCanalClient
extends AbstractCanalClient {
    private Logger log = LoggerFactory.getLogger(KafkaCanalClient.class);

    public static Builder builder() {
        return Builder.builder();
    }

    @Override
    public void process() {
        KafkaCanalConnector connector = (KafkaCanalConnector)this.getConnector();
        MessageHandler messageHandler = this.getMessageHandler();
        while (this.flag) {
            try {
                connector.connect();
                connector.subscribe();
                while (this.flag) {
                    try {
                        List messages = connector.getFlatListWithoutAck(this.timeout, this.unit);
                        this.log.info("\u83b7\u53d6\u6d88\u606f {}", (Object)messages);
                        if (messages != null) {
                            for (FlatMessage flatMessage : messages) {
                                messageHandler.handleMessage(flatMessage);
                            }
                        }
                        connector.ack();
                    }
                    catch (Exception e) {
                        this.log.error("canal \u6d88\u8d39\u5f02\u5e38", (Throwable)e);
                    }
                }
            }
            catch (Exception e) {
                this.log.error("canal \u8fde\u63a5\u5f02\u5e38", (Throwable)e);
            }
        }
        connector.unsubscribe();
        connector.disconnect();
    }

    public static final class Builder {
        private String filter = "";
        private Integer batchSize = 1;
        private Long timeout = 1L;
        private TimeUnit unit = TimeUnit.SECONDS;
        private String servers;
        private String topic;
        private Integer partition;
        private String groupId;
        private MessageHandler messageHandler;

        private Builder() {
        }

        public static Builder builder() {
            return new Builder();
        }

        public Builder servers(String servers) {
            this.servers = servers;
            return this;
        }

        public Builder topic(String topic) {
            this.topic = topic;
            return this;
        }

        public Builder partition(Integer partition) {
            this.partition = partition;
            return this;
        }

        public Builder groupId(String groupId) {
            this.groupId = groupId;
            return this;
        }

        public Builder filter(String filter) {
            this.filter = filter;
            return this;
        }

        public Builder batchSize(Integer batchSize) {
            this.batchSize = batchSize;
            return this;
        }

        public Builder timeout(Long timeout) {
            this.timeout = timeout;
            return this;
        }

        public Builder unit(TimeUnit unit) {
            this.unit = unit;
            return this;
        }

        public Builder messageHandler(MessageHandler messageHandler) {
            this.messageHandler = messageHandler;
            return this;
        }

        public KafkaCanalClient build() {
            KafkaCanalConnector connector = new KafkaCanalConnector(this.servers, this.topic, this.partition, this.groupId, this.batchSize, true);
            KafkaCanalClient kafkaCanalClient = new KafkaCanalClient();
            kafkaCanalClient.setMessageHandler(this.messageHandler);
            kafkaCanalClient.setConnector((CanalConnector)connector);
            kafkaCanalClient.filter = this.filter;
            kafkaCanalClient.unit = this.unit;
            kafkaCanalClient.batchSize = this.batchSize;
            kafkaCanalClient.timeout = this.timeout;
            return kafkaCanalClient;
        }
    }
}

