package com.aizuda.bpm.solon.autoconfigure;

import com.aizuda.bpm.beetlsql.impl.*;
import com.aizuda.bpm.beetlsql.mapper.*;
import com.aizuda.bpm.engine.dao.*;
import com.beetl.sql.pref.PerformanceConfig;
import com.github.yitter.contract.IdGeneratorOptions;
import com.github.yitter.idgen.YitIdHelper;
import org.beetl.sql.core.*;
import org.noear.solon.annotation.Bean;
import org.noear.solon.annotation.Condition;
import org.noear.solon.annotation.Configuration;
import org.noear.solon.annotation.Inject;

import javax.sql.DataSource;

@Configuration
public class FlowLongBeetlsqlConfiguration {

    @Bean
    public SQLManager sqlManager(@Inject DataSource ds) {
        ConnectionSource source = ConnectionSourceHelper.getSingle(ds);
        SQLManagerBuilder builder = new SQLManagerBuilder(source);
        SQLManager sqlManager = builder.build();
        sqlManager.setNc(new UnderlinedNameConversion());
        PerformanceConfig performanceConfig = new PerformanceConfig();
        performanceConfig.config(sqlManager);
        SQLManager.javabeanStrict(false);
        IdGeneratorOptions options = new IdGeneratorOptions((short) 50);
        options.SeqBitLength = 12;
        YitIdHelper.setIdGenerator(options);
        return sqlManager;
    }

    @Bean
    @Condition(onMissingBean = FlwExtInstanceDao.class)
    public FlwExtInstanceDao extInstanceDao(@Inject SQLManager sqlManager) {
        return new FlwExtInstanceDaoImpl(sqlManager.getMapper(FlwExtInstanceMapper.class));
    }

    @Bean
    @Condition(onMissingBean = FlwHisInstanceDao.class)
    public FlwHisInstanceDao hisInstanceDao(@Inject SQLManager sqlManager) {
        return new FlwHisInstanceDaoImpl(sqlManager.getMapper(FlwHisInstanceMapper.class));
    }

    @Bean
    @Condition(onMissingBean = FlwHisTaskActorDao.class)
    public FlwHisTaskActorDao hisTaskActorDao(@Inject SQLManager sqlManager) {
        return new FlwHisTaskActorDaoImpl(sqlManager.getMapper(FlwHisTaskActorMapper.class));
    }

    @Bean
    @Condition(onMissingBean = FlwHisTaskDao.class)
    public FlwHisTaskDao hisTaskDao(@Inject SQLManager sqlManager) {
        return new FlwHisTaskDaoImpl(sqlManager.getMapper(FlwHisTaskMapper.class));
    }

    @Bean
    @Condition(onMissingBean = FlwInstanceDao.class)
    public FlwInstanceDao instanceDao(@Inject SQLManager sqlManager) {
        return new FlwInstanceDaoImpl(sqlManager.getMapper(FlwInstanceMapper.class));
    }

    @Bean
    @Condition(onMissingBean = FlwProcessDao.class)
    public FlwProcessDao processDao(@Inject SQLManager sqlManager) {
        return new FlwProcessDaoImpl(sqlManager.getMapper(FlwProcessMapper.class));
    }

    @Bean
    @Condition(onMissingBean = FlwTaskActorDao.class)
    public FlwTaskActorDao taskActorDao(@Inject SQLManager sqlManager) {
        return new FlwTaskActorDaoImpl(sqlManager.getMapper(FlwTaskActorMapper.class));
    }

    @Bean
    @Condition(onMissingBean = FlwTaskDao.class)
    public FlwTaskDao taskDao(@Inject SQLManager sqlManager) {
        return new FlwTaskDaoImpl(sqlManager.getMapper(FlwTaskMapper.class));
    }

}
