/*
 * Decompiled with CFR 0.152.
 */
package cn.amossun.starter.event.property;

import cn.amossun.starter.event.enums.DurabilityEnum;
import cn.amossun.starter.event.enums.ExchangeTypeEnum;
import java.util.Map;
import org.springframework.amqp.core.Exchange;

public class EventExchangeContext {
    private final String exchangeName;
    private final ExchangeTypeEnum type;
    private final DurabilityEnum durability;
    private final boolean autoDelete;
    private final boolean internal;
    private final Map<String, Object> argumentsMap;
    private Exchange exchange;

    public EventExchangeContext(String exchangeName, ExchangeTypeEnum type, DurabilityEnum durability, boolean autoDelete) {
        this(exchangeName, type, durability, autoDelete, false, null);
    }

    public EventExchangeContext(String exchangeName, ExchangeTypeEnum type, DurabilityEnum durability, boolean autoDelete, boolean internal, Map<String, Object> argumentsMap) {
        this.exchangeName = exchangeName;
        this.type = type;
        this.durability = durability;
        this.autoDelete = autoDelete;
        this.internal = internal;
        this.argumentsMap = argumentsMap;
    }

    public boolean isDurable() {
        if (this.durability == null) {
            return false;
        }
        return this.durability == DurabilityEnum.DURABLE;
    }

    public String getExchangeName() {
        return this.exchangeName;
    }

    public ExchangeTypeEnum getType() {
        return this.type;
    }

    public DurabilityEnum getDurability() {
        return this.durability;
    }

    public boolean isAutoDelete() {
        return this.autoDelete;
    }

    public boolean isInternal() {
        return this.internal;
    }

    public Map<String, Object> getArgumentsMap() {
        return this.argumentsMap;
    }

    public Exchange getExchange() {
        return this.exchange;
    }

    public void setExchange(Exchange exchange) {
        this.exchange = exchange;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof EventExchangeContext)) {
            return false;
        }
        EventExchangeContext other = (EventExchangeContext)o;
        if (!other.canEqual(this)) {
            return false;
        }
        if (this.isAutoDelete() != other.isAutoDelete()) {
            return false;
        }
        if (this.isInternal() != other.isInternal()) {
            return false;
        }
        String this$exchangeName = this.getExchangeName();
        String other$exchangeName = other.getExchangeName();
        if (this$exchangeName == null ? other$exchangeName != null : !this$exchangeName.equals(other$exchangeName)) {
            return false;
        }
        ExchangeTypeEnum this$type = this.getType();
        ExchangeTypeEnum other$type = other.getType();
        if (this$type == null ? other$type != null : !((Object)((Object)this$type)).equals((Object)other$type)) {
            return false;
        }
        DurabilityEnum this$durability = this.getDurability();
        DurabilityEnum other$durability = other.getDurability();
        if (this$durability == null ? other$durability != null : !((Object)((Object)this$durability)).equals((Object)other$durability)) {
            return false;
        }
        Map<String, Object> this$argumentsMap = this.getArgumentsMap();
        Map<String, Object> other$argumentsMap = other.getArgumentsMap();
        if (this$argumentsMap == null ? other$argumentsMap != null : !((Object)this$argumentsMap).equals(other$argumentsMap)) {
            return false;
        }
        Exchange this$exchange = this.getExchange();
        Exchange other$exchange = other.getExchange();
        return !(this$exchange == null ? other$exchange != null : !this$exchange.equals(other$exchange));
    }

    protected boolean canEqual(Object other) {
        return other instanceof EventExchangeContext;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        result = result * 59 + (this.isAutoDelete() ? 79 : 97);
        result = result * 59 + (this.isInternal() ? 79 : 97);
        String $exchangeName = this.getExchangeName();
        result = result * 59 + ($exchangeName == null ? 43 : $exchangeName.hashCode());
        ExchangeTypeEnum $type = this.getType();
        result = result * 59 + ($type == null ? 43 : ((Object)((Object)$type)).hashCode());
        DurabilityEnum $durability = this.getDurability();
        result = result * 59 + ($durability == null ? 43 : ((Object)((Object)$durability)).hashCode());
        Map<String, Object> $argumentsMap = this.getArgumentsMap();
        result = result * 59 + ($argumentsMap == null ? 43 : ((Object)$argumentsMap).hashCode());
        Exchange $exchange = this.getExchange();
        result = result * 59 + ($exchange == null ? 43 : $exchange.hashCode());
        return result;
    }

    public String toString() {
        return "EventExchangeContext(exchangeName=" + this.getExchangeName() + ", type=" + (Object)((Object)this.getType()) + ", durability=" + (Object)((Object)this.getDurability()) + ", autoDelete=" + this.isAutoDelete() + ", internal=" + this.isInternal() + ", argumentsMap=" + this.getArgumentsMap() + ", exchange=" + this.getExchange() + ")";
    }
}

