/*
 * Decompiled with CFR 0.152.
 */
package cn.amossun.starter.event.property;

import cn.amossun.starter.event.property.EventBindingContext;
import cn.amossun.starter.event.property.EventExchangeContext;
import cn.amossun.starter.event.property.EventQueueContext;
import cn.amossun.starter.event.property.ListenerContext;
import cn.amossun.starter.event.property.ListenerInvokeHandler;
import cn.hutool.core.collection.CollectionUtil;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.atomic.AtomicInteger;
import org.springframework.amqp.rabbit.listener.MessageListenerContainer;

public final class EventContext {
    private final AtomicInteger counter = new AtomicInteger();
    private static final Map<String, List<ListenerInvokeHandler>> invokeHandlerMap = new HashMap<String, List<ListenerInvokeHandler>>();
    private List<EventQueueContext> queueContexts = new ArrayList<EventQueueContext>(10);
    private List<EventExchangeContext> exchangeContexts = new ArrayList<EventExchangeContext>(10);
    private List<EventBindingContext> bindingContexts = new ArrayList<EventBindingContext>(10);
    private List<ListenerContext> listenerContexts = new ArrayList<ListenerContext>(10);
    private final Map<String, MessageListenerContainer> listenerContainers = new ConcurrentHashMap<String, MessageListenerContainer>();

    public void putListenerContainer(MessageListenerContainer messageListenerContainer) {
        this.listenerContainers.put(this.getEndpointId(), messageListenerContainer);
    }

    public Collection<MessageListenerContainer> getListenerContainers() {
        return Collections.unmodifiableCollection(this.listenerContainers.values());
    }

    private String getEndpointId() {
        return "org.springframework.amqp.rabbit.RabbitListenerEndpointContainer#" + this.counter.getAndIncrement();
    }

    public void addQueue(EventQueueContext eventQueueContext) {
        if (eventQueueContext != null) {
            this.queueContexts.add(eventQueueContext);
        }
    }

    public void addQueues(List<EventQueueContext> eventQueueContexts) {
        if (CollectionUtil.isNotEmpty(eventQueueContexts)) {
            this.queueContexts.addAll(eventQueueContexts);
        }
    }

    public void addExchange(EventExchangeContext exchange) {
        if (exchange != null) {
            this.exchangeContexts.add(exchange);
        }
    }

    public void addExchanges(List<EventExchangeContext> exchanges) {
        if (CollectionUtil.isNotEmpty(exchanges)) {
            this.exchangeContexts.addAll(exchanges);
        }
    }

    public void addBinding(String beanName, String methodName, EventBindingContext binding) {
        if (binding != null) {
            this.bindingContexts.add(binding);
        }
    }

    public void addBindings(String beanName, String methodName, List<EventBindingContext> bindings) {
        if (CollectionUtil.isNotEmpty(bindings)) {
            this.bindingContexts.addAll(bindings);
        }
    }

    public List<ListenerInvokeHandler> getInvokeHandlers(String key) {
        return invokeHandlerMap.get(key);
    }

    public Map<String, List<ListenerInvokeHandler>> getInvokeHandlerMap() {
        return invokeHandlerMap;
    }

    public AtomicInteger getCounter() {
        return this.counter;
    }

    public List<EventQueueContext> getQueueContexts() {
        return this.queueContexts;
    }

    public List<EventExchangeContext> getExchangeContexts() {
        return this.exchangeContexts;
    }

    public List<EventBindingContext> getBindingContexts() {
        return this.bindingContexts;
    }

    public List<ListenerContext> getListenerContexts() {
        return this.listenerContexts;
    }

    public void setQueueContexts(List<EventQueueContext> queueContexts) {
        this.queueContexts = queueContexts;
    }

    public void setExchangeContexts(List<EventExchangeContext> exchangeContexts) {
        this.exchangeContexts = exchangeContexts;
    }

    public void setBindingContexts(List<EventBindingContext> bindingContexts) {
        this.bindingContexts = bindingContexts;
    }

    public void setListenerContexts(List<ListenerContext> listenerContexts) {
        this.listenerContexts = listenerContexts;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof EventContext)) {
            return false;
        }
        EventContext other = (EventContext)o;
        AtomicInteger this$counter = this.getCounter();
        AtomicInteger other$counter = other.getCounter();
        if (this$counter == null ? other$counter != null : !this$counter.equals(other$counter)) {
            return false;
        }
        List<EventQueueContext> this$queueContexts = this.getQueueContexts();
        List<EventQueueContext> other$queueContexts = other.getQueueContexts();
        if (this$queueContexts == null ? other$queueContexts != null : !((Object)this$queueContexts).equals(other$queueContexts)) {
            return false;
        }
        List<EventExchangeContext> this$exchangeContexts = this.getExchangeContexts();
        List<EventExchangeContext> other$exchangeContexts = other.getExchangeContexts();
        if (this$exchangeContexts == null ? other$exchangeContexts != null : !((Object)this$exchangeContexts).equals(other$exchangeContexts)) {
            return false;
        }
        List<EventBindingContext> this$bindingContexts = this.getBindingContexts();
        List<EventBindingContext> other$bindingContexts = other.getBindingContexts();
        if (this$bindingContexts == null ? other$bindingContexts != null : !((Object)this$bindingContexts).equals(other$bindingContexts)) {
            return false;
        }
        List<ListenerContext> this$listenerContexts = this.getListenerContexts();
        List<ListenerContext> other$listenerContexts = other.getListenerContexts();
        if (this$listenerContexts == null ? other$listenerContexts != null : !((Object)this$listenerContexts).equals(other$listenerContexts)) {
            return false;
        }
        Collection<MessageListenerContainer> this$listenerContainers = this.getListenerContainers();
        Collection<MessageListenerContainer> other$listenerContainers = other.getListenerContainers();
        return !(this$listenerContainers == null ? other$listenerContainers != null : !((Object)this$listenerContainers).equals(other$listenerContainers));
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        AtomicInteger $counter = this.getCounter();
        result = result * 59 + ($counter == null ? 43 : $counter.hashCode());
        List<EventQueueContext> $queueContexts = this.getQueueContexts();
        result = result * 59 + ($queueContexts == null ? 43 : ((Object)$queueContexts).hashCode());
        List<EventExchangeContext> $exchangeContexts = this.getExchangeContexts();
        result = result * 59 + ($exchangeContexts == null ? 43 : ((Object)$exchangeContexts).hashCode());
        List<EventBindingContext> $bindingContexts = this.getBindingContexts();
        result = result * 59 + ($bindingContexts == null ? 43 : ((Object)$bindingContexts).hashCode());
        List<ListenerContext> $listenerContexts = this.getListenerContexts();
        result = result * 59 + ($listenerContexts == null ? 43 : ((Object)$listenerContexts).hashCode());
        Collection<MessageListenerContainer> $listenerContainers = this.getListenerContainers();
        result = result * 59 + ($listenerContainers == null ? 43 : ((Object)$listenerContainers).hashCode());
        return result;
    }

    public String toString() {
        return "EventContext(counter=" + this.getCounter() + ", queueContexts=" + this.getQueueContexts() + ", exchangeContexts=" + this.getExchangeContexts() + ", bindingContexts=" + this.getBindingContexts() + ", listenerContexts=" + this.getListenerContexts() + ", listenerContainers=" + this.getListenerContainers() + ")";
    }
}

