/*
 * Decompiled with CFR 0.152.
 */
package cn.amossun.starter.event.listener;

import cn.amossun.starter.event.exception.EventMethodExecuteException;
import cn.amossun.starter.event.exception.EventMethodNodFoundException;
import cn.amossun.starter.event.listener.RemoteEventMessageListener;
import cn.amossun.starter.event.property.EventContext;
import cn.amossun.starter.event.property.ListenerInvokeHandler;
import cn.amossun.starter.event.property.SimpleEventMessage;
import cn.hutool.core.collection.CollectionUtil;
import com.alibaba.fastjson.JSON;
import com.rabbitmq.client.Channel;
import java.io.IOException;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.concurrent.atomic.AtomicReference;
import java.util.stream.Collectors;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.amqp.core.AcknowledgeMode;
import org.springframework.amqp.core.Message;
import org.springframework.amqp.rabbit.listener.api.ChannelAwareMessageListener;

public class SimpleRemoteEventMessageListener
implements RemoteEventMessageListener<SimpleEventMessage>,
ChannelAwareMessageListener {
    private static final Logger log = LoggerFactory.getLogger(SimpleRemoteEventMessageListener.class);
    private final ThreadLocal<AcknowledgeMode> threadLocal = new ThreadLocal();
    private EventContext eventContext;

    public SimpleRemoteEventMessageListener(EventContext eventContext) {
        this.eventContext = eventContext;
    }

    public String[] getListeningQueues() {
        return (String[])this.eventContext.getQueueContexts().stream().map(queue -> queue.getQueueName()).toArray(String[]::new);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void onMessage(Message message, Channel channel) {
        String queueName = message.getMessageProperties().getConsumerQueue();
        String messageStr = new String(message.getBody());
        SimpleEventMessage event = (SimpleEventMessage)JSON.parseObject((String)messageStr, SimpleEventMessage.class);
        log.info("\u63a5\u6536\u5230\u6765\u81ea\u961f\u5217: [{}] => {}", (Object)queueName, (Object)event);
        Boolean canAck = false;
        Boolean reQueue = false;
        try {
            this.onRemoteEvent(queueName, event);
        }
        catch (EventMethodNodFoundException e) {
            log.warn("\u672a\u627e\u5230\u76d1\u542c\u65b9\u6cd5, \u62d2\u7edd\u6d88\u8d39\u4fe1\u606f");
            canAck = true;
        }
        catch (EventMethodExecuteException e) {
            log.warn("\u8c03\u7528\u76d1\u542c\u65b9\u6cd5\u5f02\u5e38, \u62d2\u7edd\u6d88\u8d39\u4fe1\u606f");
            canAck = true;
            reQueue = e.isReTry();
        }
        catch (Exception e) {
            log.error("\u8c03\u7528\u76d1\u542c\u65b9\u6cd5\u5f02\u5e38, \u62d2\u7edd\u6d88\u8d39\u4fe1\u606f: ", (Throwable)e);
            canAck = true;
        }
        try {
            AcknowledgeMode acknowledgeMode = this.threadLocal.get();
            if (acknowledgeMode == null || acknowledgeMode.isAutoAck()) {
                return;
            }
            if (acknowledgeMode.isManual()) {
                if (canAck.booleanValue()) {
                    channel.basicNack(message.getMessageProperties().getDeliveryTag(), false, reQueue.booleanValue());
                    return;
                }
                channel.basicAck(message.getMessageProperties().getDeliveryTag(), false);
                return;
            }
            if (canAck.booleanValue() && acknowledgeMode == AcknowledgeMode.AUTO) {
                throw new EventMethodExecuteException("\u6267\u884c\u8c03\u7528\u76d1\u542c\u65b9\u6cd5\u5f02\u5e38");
            }
        }
        catch (IOException e) {
            log.error("\u6d88\u8d39\u6d88\u606fbasicAck/basicNack\u5f02\u5e38: ", (Throwable)e);
            return;
        }
        finally {
            if (this.threadLocal.get() != null) {
                this.threadLocal.remove();
            }
        }
    }

    @Override
    public void onRemoteEvent(String queueName, SimpleEventMessage event) {
        log.info("\u5f00\u59cb\u6267\u884c\u5bf9\u5e94\u76d1\u542c\u65b9\u6cd5");
        try {
            String listenerKey = String.format("%s.%s", event.getTopic(), event.getDefinition());
            String allScopesKey = String.format("%s.%s", event.getTopic(), "#");
            List listeners = Optional.ofNullable(this.eventContext.getInvokeHandlers(listenerKey)).orElseGet(() -> new ArrayList());
            List allScopesListeners = Optional.ofNullable(this.eventContext.getInvokeHandlers(allScopesKey)).orElseGet(() -> new ArrayList());
            HashSet listenerInvokeHandlers = new HashSet(listeners.size() + allScopesListeners.size());
            listenerInvokeHandlers.addAll(listeners);
            listenerInvokeHandlers.addAll(allScopesListeners);
            if (CollectionUtil.isEmpty(listenerInvokeHandlers)) {
                throw new EventMethodNodFoundException("\u76d1\u542c\u65b9\u6cd5\u672a\u627e\u5230");
            }
            Map<List, List<ListenerInvokeHandler>> queueNameMap = listenerInvokeHandlers.stream().collect(Collectors.groupingBy(ListenerInvokeHandler::getQueueNames));
            AtomicReference targetListeners = null;
            queueNameMap.entrySet().stream().forEach(queueNames -> {
                if (((List)queueNames.getKey()).contains(queueName)) {
                    targetListeners.set(queueNames.getValue());
                }
            });
            if (CollectionUtil.isEmpty((Collection)((Collection)targetListeners.get()))) {
                throw new EventMethodNodFoundException("\u961f\u5217\u6d88\u8d39\u8005\u672a\u627e\u5230");
            }
            ((List)targetListeners.get()).stream().forEach(listenerInvokeHandler -> {
                try {
                    AcknowledgeMode ackMode = listenerInvokeHandler.getListenerContext().getAckMode();
                    this.threadLocal.set(ackMode);
                    Object listenerInvokeBean = listenerInvokeHandler.getBean();
                    Method listenerInvokeMethod = listenerInvokeHandler.getMethod();
                    Class<?> targetParamClass = listenerInvokeHandler.getListenerContext().getSchemaClass();
                    Object paramData = JSON.parseObject((String)event.getMessage(), targetParamClass);
                    listenerInvokeMethod.invoke(listenerInvokeBean, paramData);
                }
                catch (Exception ex) {
                    log.error("\u6267\u884c\u8c03\u7528\u76d1\u542c\u65b9\u6cd5\u5f02\u5e38: ", (Throwable)ex);
                    throw new EventMethodExecuteException(ex.getMessage(), listenerInvokeHandler.getListenerContext().isReTry());
                }
            });
        }
        catch (EventMethodExecuteException ex) {
            throw ex;
        }
        catch (Exception ex) {
            throw new EventMethodExecuteException(ex.getMessage());
        }
    }
}

