/*
 * Decompiled with CFR 0.152.
 */
package cn.amossun.starter.event.handler;

import cn.amossun.starter.event.annoation.EventPublisher;
import cn.amossun.starter.event.exception.EventPushRemoteException;
import cn.amossun.starter.event.handler.RemoteEventMessagePublisher;
import cn.amossun.starter.event.property.SimpleEventMessage;
import com.alibaba.fastjson.JSON;
import java.lang.reflect.Method;
import java.nio.charset.Charset;
import java.util.Map;
import java.util.UUID;
import org.aspectj.lang.JoinPoint;
import org.aspectj.lang.annotation.AfterReturning;
import org.aspectj.lang.annotation.Aspect;
import org.aspectj.lang.annotation.Pointcut;
import org.aspectj.lang.reflect.MethodSignature;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.amqp.core.Message;
import org.springframework.amqp.core.MessageProperties;
import org.springframework.amqp.rabbit.connection.CorrelationData;
import org.springframework.amqp.rabbit.core.RabbitTemplate;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Qualifier;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.core.annotation.AnnotationUtils;

@Aspect
public class SimplePublisherAspect
implements RemoteEventMessagePublisher<SimpleEventMessage> {
    private static final Logger log = LoggerFactory.getLogger(SimplePublisherAspect.class);
    @Value(value="${spring.application.name}")
    private String service;
    @Autowired
    @Qualifier(value="instance")
    private String instance;
    @Autowired
    @Qualifier(value="eventRabbitTemplate")
    RabbitTemplate rabbitTemplate;

    @Pointcut(value="@annotation(cn.amossun.starter.event.annoation.EventPublisher)")
    public void pointcut() {
        log.info("\u62e6\u622a\u4e8b\u4ef6\u53d1\u5e03");
    }

    @AfterReturning(pointcut="pointcut()", returning="result")
    public void doAfterReturning(JoinPoint joinPoint, Object result) throws Throwable {
        block2: {
            MethodSignature methodSignature = (MethodSignature)joinPoint.getSignature();
            Method method = methodSignature.getMethod();
            EventPublisher eventPublisher = (EventPublisher)AnnotationUtils.findAnnotation((Method)method, EventPublisher.class);
            boolean thrownException = eventPublisher.thrownException();
            try {
                String message = JSON.toJSONString((Object)result);
                Map<String, Object> argumentsMap = this.getArgumentsMap(eventPublisher);
                String topic = this.getRoutingKey(eventPublisher);
                SimpleEventMessage eventMessage = this.eventMessage(this.service, this.instance, topic, eventPublisher.definition(), eventPublisher.description(), method.getName(), message, argumentsMap);
                String routingKey = String.format("%s.%s", topic, eventPublisher.definition().getCode());
                this.pushRemoteEvent(this.getExchangeName(eventPublisher), routingKey, eventMessage);
            }
            catch (Exception e) {
                log.error("\u53d1\u5e03\u4e8b\u4ef6\u5931\u8d25: ", (Throwable)e);
                if (!thrownException) break block2;
                throw new EventPushRemoteException(e.getMessage());
            }
        }
    }

    @Override
    public void pushRemoteEvent(String exchangeName, String routingKey, SimpleEventMessage event) {
        String eventStr = JSON.toJSONString((Object)event);
        log.info("\u5f00\u59cb\u53d1\u5e03\u4e8b\u4ef6: routing key: [{}] => {}", (Object)routingKey, (Object)event);
        CorrelationData correlationData = new CorrelationData(String.format("%s_%s", routingKey, UUID.randomUUID().toString()));
        MessageProperties messageProperties = new MessageProperties();
        messageProperties.setContentType("application/json");
        messageProperties.setContentEncoding("UTF-8");
        Message rabbitMessage = new Message(eventStr.getBytes(Charset.forName("UTF-8")), messageProperties);
        this.rabbitTemplate.send(exchangeName, routingKey, rabbitMessage, correlationData);
        log.info("\u53d1\u5e03\u4e8b\u4ef6\u6210\u529f: routing key: [{}] => {}", (Object)routingKey, (Object)event);
    }
}

