/*
 * Decompiled with CFR 0.152.
 */
package cn.amossun.starter.event.handler;

import cn.amossun.starter.event.annoation.EventMulticaster;
import cn.amossun.starter.event.exception.EventPushRemoteException;
import cn.amossun.starter.event.handler.RemoteEventMessagePublisher;
import cn.amossun.starter.event.property.SimpleEventMessage;
import com.alibaba.fastjson.JSON;
import java.lang.reflect.Method;
import java.nio.charset.Charset;
import java.util.Arrays;
import java.util.List;
import java.util.UUID;
import java.util.stream.Collectors;
import org.aspectj.lang.JoinPoint;
import org.aspectj.lang.annotation.AfterReturning;
import org.aspectj.lang.annotation.Aspect;
import org.aspectj.lang.annotation.Pointcut;
import org.aspectj.lang.reflect.MethodSignature;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.amqp.core.Message;
import org.springframework.amqp.core.MessageProperties;
import org.springframework.amqp.rabbit.connection.CorrelationData;
import org.springframework.amqp.rabbit.core.RabbitTemplate;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Qualifier;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.core.annotation.AnnotationUtils;

@Aspect
public class SimpleMulticasterAspect
implements RemoteEventMessagePublisher<SimpleEventMessage> {
    private static final Logger log = LoggerFactory.getLogger(SimpleMulticasterAspect.class);
    @Value(value="${spring.application.name}")
    private String service;
    @Autowired
    @Qualifier(value="instance")
    private String instance;
    @Autowired
    @Qualifier(value="eventRabbitTemplate")
    RabbitTemplate rabbitTemplate;

    @Pointcut(value="@annotation(cn.amossun.starter.event.annoation.EventMulticaster)")
    public void pointcut() {
        log.info("\u62e6\u622a\u5e7f\u64ad\u4e8b\u4ef6");
    }

    @AfterReturning(pointcut="pointcut()", returning="result")
    public void doAfterReturning(JoinPoint joinPoint, Object result) throws Throwable {
        block2: {
            MethodSignature methodSignature = (MethodSignature)joinPoint.getSignature();
            Method method = methodSignature.getMethod();
            EventMulticaster eventMulticaster = (EventMulticaster)AnnotationUtils.findAnnotation((Method)method, EventMulticaster.class);
            boolean thrownException = eventMulticaster.thrownException();
            try {
                String message = JSON.toJSONString((Object)result);
                List eventBindingList = Arrays.stream(eventMulticaster.bindings()).collect(Collectors.toList());
                eventBindingList.stream().forEach(eventBinding -> {
                    SimpleEventMessage eventMessage = this.eventMessage(this.service, this.instance, eventBinding.key(), eventMulticaster.definition(), eventMulticaster.description(), method.getName(), message, this.getArguments(eventBinding.arguments()));
                    String routingKey = String.format("%s.%s", eventBinding.key(), eventMulticaster.definition().getCode());
                    this.pushRemoteEvent(eventBinding.exchange().name(), routingKey, eventMessage);
                });
                log.info("\u5e7f\u64ad\u4e8b\u4ef6\u6210\u529f");
            }
            catch (Exception e) {
                log.error("\u5e7f\u64ad\u4e8b\u4ef6\u5931\u8d25: ", (Throwable)e);
                if (!thrownException) break block2;
                throw e;
            }
        }
    }

    @Override
    public void pushRemoteEvent(String exchangeName, String routingKey, SimpleEventMessage event) {
        String eventStr = JSON.toJSONString((Object)event);
        log.info("\u5f00\u59cb\u53d1\u5e03\u5e7f\u64ad\u4e8b\u4ef6: routing key: [{}] => {}", (Object)routingKey, (Object)event);
        CorrelationData correlationData = new CorrelationData(String.format("%s_%s", routingKey, UUID.randomUUID().toString()));
        MessageProperties messageProperties = new MessageProperties();
        messageProperties.setContentType("application/json");
        messageProperties.setContentEncoding("UTF-8");
        Message rabbitMessage = new Message(eventStr.getBytes(Charset.forName("UTF-8")), messageProperties);
        try {
            this.rabbitTemplate.send(exchangeName, routingKey, rabbitMessage, correlationData);
            log.info("\u53d1\u5e03\u5e7f\u64ad\u4e8b\u4ef6\u6210\u529f: routing key: [{}] => {}", (Object)routingKey, (Object)event);
        }
        catch (Exception e) {
            throw new EventPushRemoteException(e.getMessage());
        }
    }
}

