/*
 * Decompiled with CFR 0.152.
 */
package cn.amossun.starter.event.handler;

import cn.amossun.starter.event.annoation.EventListener;
import cn.amossun.starter.event.exception.EventConfigException;
import cn.amossun.starter.event.handler.ListenerInvokeHolder;
import cn.amossun.starter.event.property.EventContext;
import cn.amossun.starter.event.property.ListenerContext;
import java.lang.reflect.Method;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.amqp.core.AmqpAdmin;
import org.springframework.amqp.rabbit.core.RabbitAdmin;
import org.springframework.core.annotation.AnnotationUtils;

public class ListenerContextProcessor
implements ListenerInvokeHolder<ListenerContext> {
    private static final Logger log = LoggerFactory.getLogger(ListenerContextProcessor.class);
    private final EventContext eventContext;
    private final RabbitAdmin rabbitAdmin;

    public ListenerContextProcessor(EventContext eventContext, RabbitAdmin rabbitAdmin) {
        this.eventContext = eventContext;
        this.rabbitAdmin = rabbitAdmin;
    }

    @Override
    public ListenerContext processListenerInvoke(Object bean, String beanName, Method method) {
        EventListener eventListener = (EventListener)AnnotationUtils.findAnnotation((Method)method, EventListener.class);
        if (eventListener != null) {
            ListenerContext listenerContext = new ListenerContext(eventListener.exclusive(), eventListener.priority(), eventListener.concurrency(), eventListener.group(), eventListener.autoStartup(), eventListener.ackMode(), eventListener.getClass(), eventListener.reTry(), eventListener.prefetchCount(), this.getArguments(eventListener.arguments()), (AmqpAdmin)this.rabbitAdmin);
            listenerContext.getQueueNames().addAll(this.getQueueNames(bean, beanName, method, eventListener));
            this.eventContext.getListenerContexts().add(listenerContext);
            return listenerContext;
        }
        throw new EventConfigException("not find @EventListener");
    }

    @Override
    public void processListener(Object bean, String beanName, Method method) {
    }

    public EventContext getEventContext() {
        return this.eventContext;
    }

    public RabbitAdmin getRabbitAdmin() {
        return this.rabbitAdmin;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof ListenerContextProcessor)) {
            return false;
        }
        ListenerContextProcessor other = (ListenerContextProcessor)o;
        if (!other.canEqual(this)) {
            return false;
        }
        EventContext this$eventContext = this.getEventContext();
        EventContext other$eventContext = other.getEventContext();
        if (this$eventContext == null ? other$eventContext != null : !((Object)this$eventContext).equals(other$eventContext)) {
            return false;
        }
        RabbitAdmin this$rabbitAdmin = this.getRabbitAdmin();
        RabbitAdmin other$rabbitAdmin = other.getRabbitAdmin();
        return !(this$rabbitAdmin == null ? other$rabbitAdmin != null : !this$rabbitAdmin.equals(other$rabbitAdmin));
    }

    protected boolean canEqual(Object other) {
        return other instanceof ListenerContextProcessor;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        EventContext $eventContext = this.getEventContext();
        result = result * 59 + ($eventContext == null ? 43 : ((Object)$eventContext).hashCode());
        RabbitAdmin $rabbitAdmin = this.getRabbitAdmin();
        result = result * 59 + ($rabbitAdmin == null ? 43 : $rabbitAdmin.hashCode());
        return result;
    }

    public String toString() {
        return "ListenerContextProcessor(eventContext=" + this.getEventContext() + ", rabbitAdmin=" + this.getRabbitAdmin() + ")";
    }
}

