/*
 * Decompiled with CFR 0.152.
 */
package cn.amossun.starter.event.handler;

import cn.amossun.starter.event.listener.SimpleRemoteEventMessageListener;
import cn.amossun.starter.event.property.EventContext;
import cn.hutool.core.collection.CollectionUtil;
import java.util.HashMap;
import java.util.Map;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.amqp.core.MessageListener;
import org.springframework.amqp.rabbit.config.SimpleRabbitListenerContainerFactory;
import org.springframework.amqp.rabbit.connection.CachingConnectionFactory;
import org.springframework.amqp.rabbit.connection.ConnectionFactory;
import org.springframework.amqp.rabbit.listener.MessageListenerContainer;
import org.springframework.amqp.rabbit.listener.SimpleMessageListenerContainer;
import org.springframework.beans.factory.DisposableBean;
import org.springframework.beans.factory.InitializingBean;

public class ListenerContainerInitializer
implements InitializingBean,
DisposableBean {
    private static final Logger log = LoggerFactory.getLogger(ListenerContainerInitializer.class);
    private final EventContext eventContext;
    private final Integer prefetchCount;
    private final SimpleRemoteEventMessageListener simpleRemoteEventMessageListener;
    private final CachingConnectionFactory cachingConnectionFactory;
    private final SimpleRabbitListenerContainerFactory simpleRabbitListenerContainerFactory;

    public ListenerContainerInitializer(EventContext eventContext, Integer prefetchCount, SimpleRemoteEventMessageListener simpleRemoteEventMessageListener, CachingConnectionFactory cachingConnectionFactory, SimpleRabbitListenerContainerFactory simpleRabbitListenerContainerFactory) {
        this.eventContext = eventContext;
        this.prefetchCount = prefetchCount;
        this.simpleRemoteEventMessageListener = simpleRemoteEventMessageListener;
        this.cachingConnectionFactory = cachingConnectionFactory;
        this.simpleRabbitListenerContainerFactory = simpleRabbitListenerContainerFactory;
    }

    public void afterPropertiesSet() throws Exception {
        this.initialize();
    }

    void initialize() {
        this.eventContext.getListenerContexts().stream().forEach(listenerContext -> {
            HashMap<String, Object> args = new HashMap<String, Object>(1 + listenerContext.getArgumentsMap().size()){
                {
                    super(x0);
                    this.put("x-priority", listenerContext.getPriority());
                    if (CollectionUtil.isNotEmpty(listenerContext.getArgumentsMap())) {
                        this.putAll(listenerContext.getArgumentsMap());
                    }
                }
            };
            SimpleMessageListenerContainer listenerContainer = (SimpleMessageListenerContainer)this.simpleRabbitListenerContainerFactory.createListenerContainer();
            listenerContainer.setMessageListener((MessageListener)this.simpleRemoteEventMessageListener);
            listenerContainer.setConnectionFactory((ConnectionFactory)this.cachingConnectionFactory);
            listenerContainer.setPrefetchCount(listenerContext.getPrefetchCount() < 1 ? this.prefetchCount.intValue() : listenerContext.getPrefetchCount());
            listenerContainer.setExclusive(listenerContext.isExclusive());
            listenerContainer.setAmqpAdmin(listenerContext.getAmqpAdmin());
            listenerContainer.setConcurrency(listenerContext.getConcurrency());
            listenerContainer.setAcknowledgeMode(listenerContext.getAckMode());
            listenerContainer.addQueueNames(listenerContext.getQueueNames().toArray(new String[0]));
            listenerContainer.setAutoStartup(listenerContext.getAutoStartup().booleanValue());
            listenerContainer.setConsumerArguments((Map)args);
            if (listenerContext.getAutoStartup().booleanValue()) {
                listenerContainer.start();
            }
            this.eventContext.putListenerContainer((MessageListenerContainer)listenerContainer);
        });
    }

    public void destroy() throws Exception {
        for (MessageListenerContainer listenerContainer : this.eventContext.getListenerContainers()) {
            if (!(listenerContainer instanceof DisposableBean)) continue;
            try {
                ((DisposableBean)listenerContainer).destroy();
            }
            catch (Exception ex) {
                log.warn("Failed to destroy listener container [" + listenerContainer + "]", (Throwable)ex);
            }
        }
    }
}

