/*
 * Decompiled with CFR 0.152.
 */
package cn.amossun.starter.event.handler;

import cn.amossun.starter.event.property.EventContext;
import java.util.HashMap;
import java.util.Map;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.amqp.core.Queue;
import org.springframework.amqp.rabbit.core.RabbitAdmin;
import org.springframework.beans.factory.InitializingBean;

public class EventQueuesInitializer
implements InitializingBean {
    private static final Logger log = LoggerFactory.getLogger(EventQueuesInitializer.class);
    private EventContext eventContext;
    private RabbitAdmin rabbitAdmin;

    public EventQueuesInitializer(EventContext eventContext, RabbitAdmin rabbitAdmin) {
        this.eventContext = eventContext;
        this.rabbitAdmin = rabbitAdmin;
    }

    Map<String, Object> buildArgs() {
        HashMap<String, Object> args = new HashMap<String, Object>(2);
        args.put("x-dead-letter-exchange", "event.dead.exchange");
        args.put("x-dead-letter-routing-key", "event.dead.topic.#");
        return args;
    }

    public void afterPropertiesSet() throws Exception {
        this.initialize();
    }

    void initialize() {
        this.eventContext.getQueueContexts().stream().forEach(eventQueue -> {
            Queue queue = new Queue(eventQueue.getQueueName(), eventQueue.isDurable(), eventQueue.isExclusive(), eventQueue.isAutoDelete(), this.buildArgs());
            this.rabbitAdmin.declareQueue(queue);
            eventQueue.setQueue(queue);
        });
    }
}

