/*
 * Decompiled with CFR 0.152.
 */
package cn.amossun.starter.event.handler;

import cn.amossun.starter.event.annoation.EventListener;
import cn.amossun.starter.event.annoation.EventMulticaster;
import cn.amossun.starter.event.annoation.EventPublisher;
import cn.amossun.starter.event.handler.QueueContextHolder;
import cn.amossun.starter.event.property.EventContext;
import java.lang.reflect.Method;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.core.annotation.AnnotationUtils;

public class EventQueueContextProcessor
implements QueueContextHolder {
    private static final Logger log = LoggerFactory.getLogger(EventQueueContextProcessor.class);
    private EventContext eventContext;

    public EventQueueContextProcessor(EventContext eventContext) {
        this.eventContext = eventContext;
    }

    @Override
    public void processListener(Object bean, String beanName, Method method) {
        EventListener eventListener = (EventListener)AnnotationUtils.findAnnotation((Method)method, EventListener.class);
        if (eventListener != null) {
            String defaultQueueName = this.getQueueName(bean, beanName, method);
            this.eventContext.addQueues(this.buildEventQueueContexts(eventListener, defaultQueueName));
        }
    }

    @Override
    public void processPublisher(Object bean, String beanName, Method method) {
        EventPublisher eventPublisher = (EventPublisher)AnnotationUtils.findAnnotation((Method)method, EventPublisher.class);
        if (eventPublisher != null) {
            this.eventContext.addQueue(this.buildEventQueueContexts(eventPublisher));
        }
    }

    @Override
    public void processMulticaster(Object bean, String beanName, Method method) {
        EventMulticaster eventMulticaster = (EventMulticaster)AnnotationUtils.findAnnotation((Method)method, EventMulticaster.class);
        if (eventMulticaster != null) {
            // empty if block
        }
    }

    public EventContext getEventContext() {
        return this.eventContext;
    }

    public void setEventContext(EventContext eventContext) {
        this.eventContext = eventContext;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof EventQueueContextProcessor)) {
            return false;
        }
        EventQueueContextProcessor other = (EventQueueContextProcessor)o;
        if (!other.canEqual(this)) {
            return false;
        }
        EventContext this$eventContext = this.getEventContext();
        EventContext other$eventContext = other.getEventContext();
        return !(this$eventContext == null ? other$eventContext != null : !((Object)this$eventContext).equals(other$eventContext));
    }

    protected boolean canEqual(Object other) {
        return other instanceof EventQueueContextProcessor;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        EventContext $eventContext = this.getEventContext();
        result = result * 59 + ($eventContext == null ? 43 : ((Object)$eventContext).hashCode());
        return result;
    }

    public String toString() {
        return "EventQueueContextProcessor(eventContext=" + this.getEventContext() + ")";
    }
}

