/*
 * Decompiled with CFR 0.152.
 */
package cn.amossun.starter.event.handler;

import cn.amossun.starter.event.annoation.Argument;
import cn.amossun.starter.event.annoation.EventPublisher;
import cn.amossun.starter.event.exception.EventConfigException;
import cn.hutool.core.util.StrUtil;
import java.util.Arrays;
import java.util.HashMap;
import java.util.Map;

public interface EventMessagePublisher {
    default public String getRoutingKey(EventPublisher eventPublisher) {
        if (eventPublisher.binding() != null && eventPublisher.binding().exchange() != null) {
            return eventPublisher.binding().key();
        }
        return eventPublisher.key();
    }

    default public Map<String, Object> getArguments(Argument[] arguments) {
        HashMap<String, Object> argumentsMap = new HashMap<String, Object>(arguments.length);
        Arrays.asList(arguments).stream().forEach(source -> argumentsMap.put(source.key(), source.value()));
        return argumentsMap;
    }

    default public Map<String, Object> getArgumentsMap(EventPublisher eventPublisher) {
        Argument[] arguments = eventPublisher.binding() != null ? eventPublisher.binding().arguments() : (eventPublisher.exchange() != null ? eventPublisher.exchange().arguments() : eventPublisher.arguments());
        HashMap<String, Object> argumentsMap = new HashMap<String, Object>(arguments.length);
        Arrays.asList(arguments).stream().forEach(source -> argumentsMap.put(source.key(), source.value()));
        return argumentsMap;
    }

    default public String getExchangeName(EventPublisher eventPublisher) {
        if (eventPublisher.binding() != null && eventPublisher.binding().exchange() != null) {
            return eventPublisher.binding().exchange().name();
        }
        if (eventPublisher.exchange() != null) {
            return eventPublisher.exchange().name();
        }
        return this.getDefaultExchangeName(eventPublisher.defaultTopicExchange(), eventPublisher.defaultHeadersExchange());
    }

    default public String getDefaultExchangeName(boolean defaultTopicExchange, boolean defaultHeadersExchange) {
        String defaultExchangeName;
        String string = defaultTopicExchange ? "event.topic.exchange" : (defaultExchangeName = defaultHeadersExchange ? "event.header.exchange" : null);
        if (StrUtil.isEmpty((CharSequence)defaultExchangeName)) {
            throw new EventConfigException("missing default 'Exchange' config");
        }
        return defaultExchangeName;
    }
}

