/*
 * Decompiled with CFR 0.152.
 */
package cn.amossun.starter.event.handler;

import cn.amossun.starter.event.enums.DurabilityEnum;
import cn.amossun.starter.event.enums.ExchangeTypeEnum;
import cn.amossun.starter.event.property.EventContext;
import cn.amossun.starter.event.property.EventExchangeContext;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.amqp.core.CustomExchange;
import org.springframework.amqp.core.DirectExchange;
import org.springframework.amqp.core.Exchange;
import org.springframework.amqp.core.FanoutExchange;
import org.springframework.amqp.core.HeadersExchange;
import org.springframework.amqp.core.TopicExchange;
import org.springframework.amqp.rabbit.core.RabbitAdmin;
import org.springframework.beans.factory.InitializingBean;

public class EventExchangeInitializer
implements InitializingBean {
    private static final Logger log = LoggerFactory.getLogger(EventExchangeInitializer.class);
    private EventContext eventContext;
    private RabbitAdmin rabbitAdmin;

    public EventExchangeInitializer(EventContext eventContext, RabbitAdmin rabbitAdmin) {
        this.eventContext = eventContext;
        this.rabbitAdmin = rabbitAdmin;
        this.addSystemExchanges();
    }

    private void addSystemExchanges() {
        this.eventContext.getExchangeContexts().add(new EventExchangeContext("event.topic.exchange", ExchangeTypeEnum.TOPIC, DurabilityEnum.DURABLE, false));
        this.eventContext.getExchangeContexts().add(new EventExchangeContext("event.header.exchange", ExchangeTypeEnum.HEADERS, DurabilityEnum.DURABLE, false));
        this.eventContext.getExchangeContexts().add(new EventExchangeContext("event.dead.exchange", ExchangeTypeEnum.DIRECT, DurabilityEnum.DURABLE, false));
    }

    public void afterPropertiesSet() throws Exception {
        this.initialize();
    }

    void initialize() {
        this.eventContext.getExchangeContexts().stream().forEach(exchangeContext -> {
            TopicExchange exchange = null;
            switch (exchangeContext.getType().getTypeValue()) {
                case "topic": {
                    exchange = new TopicExchange(exchangeContext.getExchangeName(), exchangeContext.isDurable(), exchangeContext.isAutoDelete(), exchangeContext.getArgumentsMap());
                    break;
                }
                case "direct": {
                    exchange = new DirectExchange(exchangeContext.getExchangeName(), exchangeContext.isDurable(), exchangeContext.isAutoDelete(), exchangeContext.getArgumentsMap());
                    break;
                }
                case "headers": {
                    exchange = new HeadersExchange(exchangeContext.getExchangeName(), exchangeContext.isDurable(), exchangeContext.isAutoDelete(), exchangeContext.getArgumentsMap());
                    break;
                }
                case "fanout": {
                    exchange = new FanoutExchange(exchangeContext.getExchangeName(), exchangeContext.isDurable(), exchangeContext.isAutoDelete(), exchangeContext.getArgumentsMap());
                    break;
                }
                case "system": {
                    exchange = new CustomExchange(exchangeContext.getExchangeName(), "system", exchangeContext.isDurable(), exchangeContext.isAutoDelete(), exchangeContext.getArgumentsMap());
                }
            }
            this.rabbitAdmin.declareExchange(exchange);
            exchangeContext.setExchange((Exchange)exchange);
        });
    }
}

