/*
 * Decompiled with CFR 0.152.
 */
package cn.amossun.starter.event.handler;

import cn.amossun.starter.event.annoation.EventBinding;
import cn.amossun.starter.event.annoation.EventExchange;
import cn.amossun.starter.event.annoation.EventListener;
import cn.amossun.starter.event.annoation.EventMulticaster;
import cn.amossun.starter.event.annoation.EventPublisher;
import cn.amossun.starter.event.handler.ExchangeContextHolder;
import cn.amossun.starter.event.property.EventContext;
import cn.amossun.starter.event.property.EventExchangeContext;
import cn.hutool.core.collection.CollectionUtil;
import cn.hutool.core.util.StrUtil;
import java.lang.reflect.Method;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.stream.Collectors;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.core.annotation.AnnotationUtils;

public class EventExchangeContextProcessor
implements ExchangeContextHolder {
    private static final Logger log = LoggerFactory.getLogger(EventExchangeContextProcessor.class);
    private EventContext eventContext;

    public EventExchangeContextProcessor(EventContext eventContext) {
        this.eventContext = eventContext;
    }

    @Override
    public void processListener(Object bean, String beanName, Method method) {
        EventListener eventListener = (EventListener)AnnotationUtils.findAnnotation((Method)method, EventListener.class);
        if (eventListener != null) {
            this.eventContext.addExchanges(this.buildEventExchangeContexts(eventListener));
        }
    }

    @Override
    public void processPublisher(Object bean, String beanName, Method method) {
        EventPublisher eventPublisher = (EventPublisher)AnnotationUtils.findAnnotation((Method)method, EventPublisher.class);
        if (eventPublisher != null) {
            this.eventContext.addExchange(this.buildEventExchangeContexts(eventPublisher));
        }
    }

    @Override
    public void processMulticaster(Object bean, String beanName, Method method) {
        EventMulticaster eventMulticaster = (EventMulticaster)AnnotationUtils.findAnnotation((Method)method, EventMulticaster.class);
        if (eventMulticaster != null) {
            // empty if block
        }
    }

    @Override
    public List<EventExchangeContext> buildEventExchangeContexts(EventListener eventListener) {
        if (eventListener.bindings().length > 0 && CollectionUtil.isNotEmpty((Collection)Arrays.stream(eventListener.bindings()).map(EventBinding::exchange).collect(Collectors.toList()))) {
            return Arrays.stream(eventListener.bindings()).map(EventBinding::exchange).map(eventExchange -> this.process((EventExchange)eventExchange)).collect(Collectors.toList());
        }
        return null;
    }

    @Override
    public EventExchangeContext buildEventExchangeContexts(EventPublisher eventPublisher) {
        if (eventPublisher.binding() != null && eventPublisher.binding().exchange() != null && StrUtil.isNotEmpty((CharSequence)eventPublisher.binding().exchange().name()) && StrUtil.isNotEmpty((CharSequence)eventPublisher.binding().exchange().value())) {
            return this.process(eventPublisher.binding().exchange());
        }
        if (eventPublisher.exchange() != null && StrUtil.isNotEmpty((CharSequence)eventPublisher.exchange().name()) && StrUtil.isNotEmpty((CharSequence)eventPublisher.exchange().value())) {
            return this.process(eventPublisher.exchange());
        }
        return null;
    }

    public EventContext getEventContext() {
        return this.eventContext;
    }

    public void setEventContext(EventContext eventContext) {
        this.eventContext = eventContext;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof EventExchangeContextProcessor)) {
            return false;
        }
        EventExchangeContextProcessor other = (EventExchangeContextProcessor)o;
        if (!other.canEqual(this)) {
            return false;
        }
        EventContext this$eventContext = this.getEventContext();
        EventContext other$eventContext = other.getEventContext();
        return !(this$eventContext == null ? other$eventContext != null : !((Object)this$eventContext).equals(other$eventContext));
    }

    protected boolean canEqual(Object other) {
        return other instanceof EventExchangeContextProcessor;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        EventContext $eventContext = this.getEventContext();
        result = result * 59 + ($eventContext == null ? 43 : ((Object)$eventContext).hashCode());
        return result;
    }

    public String toString() {
        return "EventExchangeContextProcessor(eventContext=" + this.getEventContext() + ")";
    }
}

