/*
 * Decompiled with CFR 0.152.
 */
package cn.amossun.starter.event.handler;

import cn.amossun.starter.event.annoation.EventBinding;
import cn.amossun.starter.event.annoation.EventListener;
import cn.amossun.starter.event.annoation.EventMulticaster;
import cn.amossun.starter.event.annoation.EventPublisher;
import cn.amossun.starter.event.annoation.EventQueue;
import cn.amossun.starter.event.exception.EventConfigException;
import cn.amossun.starter.event.handler.BindingContextHolder;
import cn.amossun.starter.event.handler.EventContextHolder;
import cn.amossun.starter.event.handler.ListenerInvokeHolder;
import cn.amossun.starter.event.handler.QueueContextHolder;
import cn.amossun.starter.event.property.EventContext;
import cn.amossun.starter.event.property.ListenerContext;
import cn.amossun.starter.event.property.ListenerInvokeHandler;
import cn.hutool.core.collection.CollectionUtil;
import cn.hutool.core.util.StrUtil;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.stream.Collectors;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.BeansException;
import org.springframework.beans.factory.config.BeanPostProcessor;
import org.springframework.core.annotation.AnnotationUtils;
import org.springframework.util.ReflectionUtils;

public class EventContextProcessor
implements BeanPostProcessor,
EventContextHolder {
    private static final Logger log = LoggerFactory.getLogger(EventContextProcessor.class);
    private EventContext eventContext;
    private QueueContextHolder queueContextHolder;
    private BindingContextHolder bindingContextHolder;
    private List<EventContextHolder> eventContextHolderList;
    private ListenerInvokeHolder<ListenerContext> listenerInvokeHolder;

    public Object postProcessBeforeInitialization(Object bean, String beanName) throws BeansException {
        return bean;
    }

    public Object postProcessAfterInitialization(Object bean, String beanName) throws BeansException {
        Method[] methods = ReflectionUtils.getAllDeclaredMethods(bean.getClass());
        if (methods != null) {
            for (Method method : methods) {
                this.processListener(bean, beanName, method);
                this.processPublisher(bean, beanName, method);
                this.processMulticaster(bean, beanName, method);
            }
        }
        return bean;
    }

    @Override
    public void processMulticaster(Object bean, String beanName, Method method) {
        EventMulticaster eventMulticaster = (EventMulticaster)AnnotationUtils.findAnnotation((Method)method, EventMulticaster.class);
        if (eventMulticaster != null) {
            this.validation(eventMulticaster);
            this.eventContextHolderList.stream().forEach(eventContextHolder -> eventContextHolder.processMulticaster(bean, beanName, method));
        }
    }

    @Override
    public void processPublisher(Object bean, String beanName, Method method) {
        EventPublisher eventPublisher = (EventPublisher)AnnotationUtils.findAnnotation((Method)method, EventPublisher.class);
        if (eventPublisher != null) {
            this.validation(eventPublisher);
            this.eventContextHolderList.stream().forEach(eventContextHolder -> eventContextHolder.processPublisher(bean, beanName, method));
        }
    }

    @Override
    public void processListener(Object bean, String beanName, Method method) {
        EventListener eventListener = (EventListener)AnnotationUtils.findAnnotation((Method)method, EventListener.class);
        if (eventListener != null) {
            this.validation(eventListener);
            this.eventContextHolderList.stream().forEach(eventContextHolder -> eventContextHolder.processListener(bean, beanName, method));
            List<String> queueNames = this.queueContextHolder.getQueueNames(bean, beanName, method, eventListener);
            ListenerContext listenerContext = this.listenerInvokeHolder.processListenerInvoke(bean, beanName, method);
            ListenerInvokeHandler listenerInvokeHandler = new ListenerInvokeHandler(queueNames, bean, method, listenerContext);
            List<String> listenerKeys = this.bindingContextHolder.getListenerKeys(eventListener);
            this.addListenerInvokeBean(listenerKeys, listenerInvokeHandler);
        }
    }

    protected void addListenerInvokeBean(List<String> listenerKeys, ListenerInvokeHandler listenerInvokeHandler) {
        listenerKeys.stream().forEach(listenerKey -> {
            List listenerInvokeHandlers = this.getListenerInvokeHandlers((String)listenerKey);
            listenerInvokeHandlers.add(listenerInvokeHandler);
            this.eventContext.getInvokeHandlerMap().put((String)listenerKey, listenerInvokeHandlers);
        });
    }

    protected List getListenerInvokeHandlers(String listenerKey) {
        List<ListenerInvokeHandler> listenerInvokeHandlers = this.eventContext.getInvokeHandlerMap().get(listenerKey);
        if (null == listenerInvokeHandlers) {
            listenerInvokeHandlers = new ArrayList<ListenerInvokeHandler>(5);
        }
        return listenerInvokeHandlers;
    }

    protected void validation(EventMulticaster eventMulticaster) {
        if (eventMulticaster == null) {
            throw new NullPointerException("@EventMulticaster can not be empty");
        }
        if (CollectionUtil.isEmpty(Arrays.asList(eventMulticaster.bindings())) || CollectionUtil.isEmpty((Collection)Arrays.stream(eventMulticaster.bindings()).map(EventBinding::key).collect(Collectors.toList()))) {
            throw new EventConfigException("@EventMulticaster keys or bindings can not be empty");
        }
        if (eventMulticaster.bindings().length > 1) {
            List<EventBinding> eventBindingList = Arrays.asList(eventMulticaster.bindings());
            eventBindingList.stream().forEach(source -> {
                if (StrUtil.isEmpty((CharSequence)source.key())) {
                    throw new EventConfigException("@EventMulticaster bindings key can not be empty");
                }
            });
        }
    }

    protected void validation(EventPublisher eventPublisher) {
        if (eventPublisher == null) {
            throw new NullPointerException("@EventPublisher can not be empty");
        }
        if (!eventPublisher.defaultTopicExchange() && !eventPublisher.defaultHeadersExchange() && eventPublisher.exchange() == null) {
            throw new EventConfigException("@EventPublisher exchange can not be empty");
        }
        if (!eventPublisher.defaultTopicExchange() && !eventPublisher.defaultHeadersExchange() && StrUtil.isEmpty((CharSequence)eventPublisher.exchange().name())) {
            throw new EventConfigException("@EventPublisher exchange name can not be empty");
        }
        if (StrUtil.isNotEmpty((CharSequence)eventPublisher.binding().key()) && StrUtil.isEmpty((CharSequence)eventPublisher.binding().exchange().name())) {
            throw new EventConfigException("@EventPublisher binding, exchange name can not be empty");
        }
        if (StrUtil.isNotEmpty((CharSequence)eventPublisher.binding().key()) && StrUtil.isEmpty((CharSequence)eventPublisher.binding().queue().name())) {
            throw new EventConfigException("@EventPublisher binding, queue name can not be empty");
        }
    }

    protected void validation(EventListener eventListener) {
        if (eventListener == null) {
            throw new NullPointerException("@EventListener can not be empty");
        }
        if (StrUtil.isEmpty((CharSequence)eventListener.key()) && eventListener.queuesToDeclare().length <= 0 && eventListener.bindings().length <= 0) {
            throw new EventConfigException("@EventListener key or queuesToDeclare or bindings can not be empty");
        }
        if (StrUtil.isNotEmpty((CharSequence)eventListener.key()) && eventListener.queuesToDeclare().length > 0 && eventListener.bindings().length > 0) {
            throw new EventConfigException("@EventListener can have only one of 'key', 'queuesToDeclare', or 'bindings'");
        }
        if (eventListener.queuesToDeclare().length > 1) {
            List<EventQueue> eventQueueList = Arrays.asList(eventListener.queuesToDeclare());
            eventQueueList.stream().forEach(source -> {
                if (StrUtil.isEmpty((CharSequence)source.name())) {
                    throw new EventConfigException("@EventListener queuesToDeclare name can not be empty");
                }
            });
        }
        if (eventListener.bindings().length > 1) {
            List<EventBinding> eventBindingList = Arrays.asList(eventListener.bindings());
            eventBindingList.stream().forEach(source -> {
                if (StrUtil.isEmpty((CharSequence)source.key())) {
                    throw new EventConfigException("@EventListener bindings key can not be empty");
                }
            });
        }
    }

    public EventContext getEventContext() {
        return this.eventContext;
    }

    public QueueContextHolder getQueueContextHolder() {
        return this.queueContextHolder;
    }

    public BindingContextHolder getBindingContextHolder() {
        return this.bindingContextHolder;
    }

    public List<EventContextHolder> getEventContextHolderList() {
        return this.eventContextHolderList;
    }

    public ListenerInvokeHolder<ListenerContext> getListenerInvokeHolder() {
        return this.listenerInvokeHolder;
    }

    public void setEventContext(EventContext eventContext) {
        this.eventContext = eventContext;
    }

    public void setQueueContextHolder(QueueContextHolder queueContextHolder) {
        this.queueContextHolder = queueContextHolder;
    }

    public void setBindingContextHolder(BindingContextHolder bindingContextHolder) {
        this.bindingContextHolder = bindingContextHolder;
    }

    public void setEventContextHolderList(List<EventContextHolder> eventContextHolderList) {
        this.eventContextHolderList = eventContextHolderList;
    }

    public void setListenerInvokeHolder(ListenerInvokeHolder<ListenerContext> listenerInvokeHolder) {
        this.listenerInvokeHolder = listenerInvokeHolder;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof EventContextProcessor)) {
            return false;
        }
        EventContextProcessor other = (EventContextProcessor)o;
        if (!other.canEqual(this)) {
            return false;
        }
        EventContext this$eventContext = this.getEventContext();
        EventContext other$eventContext = other.getEventContext();
        if (this$eventContext == null ? other$eventContext != null : !((Object)this$eventContext).equals(other$eventContext)) {
            return false;
        }
        QueueContextHolder this$queueContextHolder = this.getQueueContextHolder();
        QueueContextHolder other$queueContextHolder = other.getQueueContextHolder();
        if (this$queueContextHolder == null ? other$queueContextHolder != null : !this$queueContextHolder.equals(other$queueContextHolder)) {
            return false;
        }
        BindingContextHolder this$bindingContextHolder = this.getBindingContextHolder();
        BindingContextHolder other$bindingContextHolder = other.getBindingContextHolder();
        if (this$bindingContextHolder == null ? other$bindingContextHolder != null : !this$bindingContextHolder.equals(other$bindingContextHolder)) {
            return false;
        }
        List<EventContextHolder> this$eventContextHolderList = this.getEventContextHolderList();
        List<EventContextHolder> other$eventContextHolderList = other.getEventContextHolderList();
        if (this$eventContextHolderList == null ? other$eventContextHolderList != null : !((Object)this$eventContextHolderList).equals(other$eventContextHolderList)) {
            return false;
        }
        ListenerInvokeHolder<ListenerContext> this$listenerInvokeHolder = this.getListenerInvokeHolder();
        ListenerInvokeHolder<ListenerContext> other$listenerInvokeHolder = other.getListenerInvokeHolder();
        return !(this$listenerInvokeHolder == null ? other$listenerInvokeHolder != null : !this$listenerInvokeHolder.equals(other$listenerInvokeHolder));
    }

    protected boolean canEqual(Object other) {
        return other instanceof EventContextProcessor;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        EventContext $eventContext = this.getEventContext();
        result = result * 59 + ($eventContext == null ? 43 : ((Object)$eventContext).hashCode());
        QueueContextHolder $queueContextHolder = this.getQueueContextHolder();
        result = result * 59 + ($queueContextHolder == null ? 43 : $queueContextHolder.hashCode());
        BindingContextHolder $bindingContextHolder = this.getBindingContextHolder();
        result = result * 59 + ($bindingContextHolder == null ? 43 : $bindingContextHolder.hashCode());
        List<EventContextHolder> $eventContextHolderList = this.getEventContextHolderList();
        result = result * 59 + ($eventContextHolderList == null ? 43 : ((Object)$eventContextHolderList).hashCode());
        ListenerInvokeHolder<ListenerContext> $listenerInvokeHolder = this.getListenerInvokeHolder();
        result = result * 59 + ($listenerInvokeHolder == null ? 43 : $listenerInvokeHolder.hashCode());
        return result;
    }

    public String toString() {
        return "EventContextProcessor(eventContext=" + this.getEventContext() + ", queueContextHolder=" + this.getQueueContextHolder() + ", bindingContextHolder=" + this.getBindingContextHolder() + ", eventContextHolderList=" + this.getEventContextHolderList() + ", listenerInvokeHolder=" + this.getListenerInvokeHolder() + ")";
    }

    public EventContextProcessor() {
    }

    public EventContextProcessor(EventContext eventContext, QueueContextHolder queueContextHolder, BindingContextHolder bindingContextHolder, List<EventContextHolder> eventContextHolderList, ListenerInvokeHolder<ListenerContext> listenerInvokeHolder) {
        this.eventContext = eventContext;
        this.queueContextHolder = queueContextHolder;
        this.bindingContextHolder = bindingContextHolder;
        this.eventContextHolderList = eventContextHolderList;
        this.listenerInvokeHolder = listenerInvokeHolder;
    }
}

