/*
 * Decompiled with CFR 0.152.
 */
package cn.amossun.starter.event.handler;

import cn.amossun.starter.event.property.EventContext;
import cn.amossun.starter.event.property.EventExchangeContext;
import cn.amossun.starter.event.property.EventQueueContext;
import java.util.Map;
import java.util.function.Function;
import java.util.stream.Collectors;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.amqp.core.Binding;
import org.springframework.amqp.core.BindingBuilder;
import org.springframework.amqp.core.DirectExchange;
import org.springframework.amqp.core.Exchange;
import org.springframework.amqp.core.FanoutExchange;
import org.springframework.amqp.core.HeadersExchange;
import org.springframework.amqp.core.Queue;
import org.springframework.amqp.core.TopicExchange;
import org.springframework.amqp.rabbit.core.RabbitAdmin;
import org.springframework.beans.factory.InitializingBean;

public class EventBindingInitializer
implements InitializingBean {
    private static final Logger log = LoggerFactory.getLogger(EventBindingInitializer.class);
    private EventContext eventContext;
    private RabbitAdmin rabbitAdmin;

    public EventBindingInitializer(EventContext eventContext, RabbitAdmin rabbitAdmin) {
        this.eventContext = eventContext;
        this.rabbitAdmin = rabbitAdmin;
    }

    public void afterPropertiesSet() throws Exception {
        this.initialize();
    }

    void initialize() {
        Map queueMap = this.eventContext.getQueueContexts().stream().collect(Collectors.toMap(EventQueueContext::getQueueName, Function.identity(), (exiting, replacement) -> exiting));
        Map exchangeMap = this.eventContext.getExchangeContexts().stream().collect(Collectors.toMap(EventExchangeContext::getExchangeName, Function.identity(), (exiting, replacement) -> exiting));
        this.eventContext.getBindingContexts().stream().forEach(bindingContext -> {
            Binding binding = null;
            EventExchangeContext eventExchangeContext = (EventExchangeContext)exchangeMap.get(bindingContext.getExchangeName());
            EventQueueContext eventQueueContext = (EventQueueContext)queueMap.get(bindingContext.getQueueName());
            BindingBuilder.DestinationConfigurer destinationConfigurer = eventQueueContext != null && eventQueueContext.getQueue() != null ? BindingBuilder.bind((Queue)eventQueueContext.getQueue()) : BindingBuilder.bind((Exchange)eventExchangeContext.getExchange());
            switch (bindingContext.getExchangeTypeEnum().getTypeValue()) {
                case "topic": {
                    binding = destinationConfigurer.to((TopicExchange)eventExchangeContext.getExchange()).with(bindingContext.getRoutingKey());
                    break;
                }
                case "direct": {
                    binding = destinationConfigurer.to((DirectExchange)eventExchangeContext.getExchange()).with(bindingContext.getRoutingKey());
                    break;
                }
                case "headers": {
                    binding = destinationConfigurer.to((HeadersExchange)eventExchangeContext.getExchange()).whereAll(bindingContext.getArgumentsMap()).match();
                    break;
                }
                case "fanout": {
                    binding = destinationConfigurer.to((FanoutExchange)eventExchangeContext.getExchange());
                    break;
                }
                case "system": {
                    binding = destinationConfigurer.to(eventExchangeContext.getExchange()).with(bindingContext.getRoutingKey()).and(bindingContext.getArgumentsMap());
                }
            }
            if (binding == null) {
                log.warn("The current exchangeType '{}' is not initialized.", (Object)bindingContext.getExchangeTypeEnum().getTypeValue());
                return;
            }
            this.rabbitAdmin.declareBinding(binding);
        });
    }
}

