/*
 * Decompiled with CFR 0.152.
 */
package cn.amossun.starter.event.handler;

import cn.amossun.starter.event.annoation.EventBinding;
import cn.amossun.starter.event.annoation.EventListener;
import cn.amossun.starter.event.annoation.EventMulticaster;
import cn.amossun.starter.event.annoation.EventPublisher;
import cn.amossun.starter.event.enums.ExchangeTypeEnum;
import cn.amossun.starter.event.handler.BindingContextHolder;
import cn.amossun.starter.event.handler.EventExchangeContextProcessor;
import cn.amossun.starter.event.handler.EventQueueContextProcessor;
import cn.amossun.starter.event.property.EventBindingContext;
import cn.amossun.starter.event.property.EventContext;
import cn.hutool.core.collection.CollectionUtil;
import cn.hutool.core.util.StrUtil;
import java.lang.reflect.Method;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.stream.Collectors;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.core.annotation.AnnotationUtils;

public class EventBindingContextProcessor
implements BindingContextHolder {
    private static final Logger log = LoggerFactory.getLogger(EventBindingContextProcessor.class);
    private EventContext eventContext;
    private EventQueueContextProcessor eventQueueContextProcessor;
    private EventExchangeContextProcessor eventExchangeContextProcessor;

    @Override
    public void processListener(Object bean, String beanName, Method method) {
        EventListener eventListener = (EventListener)AnnotationUtils.findAnnotation((Method)method, EventListener.class);
        if (eventListener != null) {
            this.eventContext.addBindings(beanName, method.getName(), this.buildEventBindingsContexts(eventListener, this.getRoutingKey(eventListener), this.eventQueueContextProcessor.getQueueName(bean, beanName, method)));
        }
    }

    @Override
    public void processPublisher(Object bean, String beanName, Method method) {
        EventPublisher eventPublisher = (EventPublisher)AnnotationUtils.findAnnotation((Method)method, EventPublisher.class);
        if (eventPublisher != null) {
            this.eventContext.addBinding(beanName, method.getName(), this.buildEventBindingsContext(eventPublisher));
        }
    }

    @Override
    public void processMulticaster(Object bean, String beanName, Method method) {
        EventMulticaster eventMulticaster = (EventMulticaster)AnnotationUtils.findAnnotation((Method)method, EventMulticaster.class);
        if (eventMulticaster != null) {
            // empty if block
        }
    }

    @Override
    public List<EventBindingContext> buildEventBindingsContexts(EventListener eventListener, String defaultListenerKey, String defaultQueueName) {
        if (eventListener.bindings().length > 0 && CollectionUtil.isNotEmpty((Collection)Arrays.stream(eventListener.bindings()).map(EventBinding::queue).collect(Collectors.toList()))) {
            return Arrays.stream(eventListener.bindings()).map(eventBinding -> this.process((EventBinding)eventBinding, eventListener.definition())).collect(Collectors.toList());
        }
        EventBindingContext eventBindingContext = new EventBindingContext(defaultListenerKey, "event.topic.exchange", ExchangeTypeEnum.TOPIC, defaultQueueName, this.getArguments(eventListener.arguments()));
        return Arrays.asList(eventBindingContext);
    }

    @Override
    public EventBindingContext buildEventBindingsContext(EventPublisher eventPublisher) {
        if (eventPublisher.binding() != null && StrUtil.isNotEmpty((CharSequence)eventPublisher.binding().key()) && eventPublisher.binding().exchange() != null && StrUtil.isNotEmpty((CharSequence)eventPublisher.binding().exchange().name()) && StrUtil.isNotEmpty((CharSequence)eventPublisher.binding().exchange().value())) {
            return this.process(eventPublisher.binding(), eventPublisher.definition());
        }
        if (eventPublisher.exchange() != null && StrUtil.isNotEmpty((CharSequence)eventPublisher.exchange().name()) && StrUtil.isNotEmpty((CharSequence)eventPublisher.exchange().value())) {
            EventBindingContext eventBindingContext = new EventBindingContext(String.format("%s.%s", eventPublisher.key(), eventPublisher.definition().getCode()), eventPublisher.exchange().name(), eventPublisher.exchange().type(), null, this.getArguments(eventPublisher.exchange().arguments()));
            return eventBindingContext;
        }
        return null;
    }

    public EventContext getEventContext() {
        return this.eventContext;
    }

    public EventQueueContextProcessor getEventQueueContextProcessor() {
        return this.eventQueueContextProcessor;
    }

    public EventExchangeContextProcessor getEventExchangeContextProcessor() {
        return this.eventExchangeContextProcessor;
    }

    public void setEventContext(EventContext eventContext) {
        this.eventContext = eventContext;
    }

    public void setEventQueueContextProcessor(EventQueueContextProcessor eventQueueContextProcessor) {
        this.eventQueueContextProcessor = eventQueueContextProcessor;
    }

    public void setEventExchangeContextProcessor(EventExchangeContextProcessor eventExchangeContextProcessor) {
        this.eventExchangeContextProcessor = eventExchangeContextProcessor;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof EventBindingContextProcessor)) {
            return false;
        }
        EventBindingContextProcessor other = (EventBindingContextProcessor)o;
        if (!other.canEqual(this)) {
            return false;
        }
        EventContext this$eventContext = this.getEventContext();
        EventContext other$eventContext = other.getEventContext();
        if (this$eventContext == null ? other$eventContext != null : !((Object)this$eventContext).equals(other$eventContext)) {
            return false;
        }
        EventQueueContextProcessor this$eventQueueContextProcessor = this.getEventQueueContextProcessor();
        EventQueueContextProcessor other$eventQueueContextProcessor = other.getEventQueueContextProcessor();
        if (this$eventQueueContextProcessor == null ? other$eventQueueContextProcessor != null : !((Object)this$eventQueueContextProcessor).equals(other$eventQueueContextProcessor)) {
            return false;
        }
        EventExchangeContextProcessor this$eventExchangeContextProcessor = this.getEventExchangeContextProcessor();
        EventExchangeContextProcessor other$eventExchangeContextProcessor = other.getEventExchangeContextProcessor();
        return !(this$eventExchangeContextProcessor == null ? other$eventExchangeContextProcessor != null : !((Object)this$eventExchangeContextProcessor).equals(other$eventExchangeContextProcessor));
    }

    protected boolean canEqual(Object other) {
        return other instanceof EventBindingContextProcessor;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        EventContext $eventContext = this.getEventContext();
        result = result * 59 + ($eventContext == null ? 43 : ((Object)$eventContext).hashCode());
        EventQueueContextProcessor $eventQueueContextProcessor = this.getEventQueueContextProcessor();
        result = result * 59 + ($eventQueueContextProcessor == null ? 43 : ((Object)$eventQueueContextProcessor).hashCode());
        EventExchangeContextProcessor $eventExchangeContextProcessor = this.getEventExchangeContextProcessor();
        result = result * 59 + ($eventExchangeContextProcessor == null ? 43 : ((Object)$eventExchangeContextProcessor).hashCode());
        return result;
    }

    public String toString() {
        return "EventBindingContextProcessor(eventContext=" + this.getEventContext() + ", eventQueueContextProcessor=" + this.getEventQueueContextProcessor() + ", eventExchangeContextProcessor=" + this.getEventExchangeContextProcessor() + ")";
    }

    public EventBindingContextProcessor(EventContext eventContext, EventQueueContextProcessor eventQueueContextProcessor, EventExchangeContextProcessor eventExchangeContextProcessor) {
        this.eventContext = eventContext;
        this.eventQueueContextProcessor = eventQueueContextProcessor;
        this.eventExchangeContextProcessor = eventExchangeContextProcessor;
    }
}

