/*
 * Decompiled with CFR 0.152.
 */
package cn.amossun.starter.event.handler;

import cn.amossun.starter.event.EventDefinition;
import cn.amossun.starter.event.annoation.EventBinding;
import cn.amossun.starter.event.annoation.EventListener;
import cn.amossun.starter.event.annoation.EventPublisher;
import cn.amossun.starter.event.handler.EventContextHolder;
import cn.amossun.starter.event.property.EventBindingContext;
import cn.hutool.core.collection.CollectionUtil;
import cn.hutool.core.util.StrUtil;
import java.util.Arrays;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;

public interface BindingContextHolder
extends EventContextHolder {
    default public EventBindingContext process(EventBinding eventBinding, EventDefinition.Scope definition) {
        if (StrUtil.isEmpty((CharSequence)eventBinding.key())) {
            return null;
        }
        Map<String, Object> argumentsMap = this.getArguments(eventBinding.arguments());
        EventBindingContext eventBindingContext = new EventBindingContext(String.format("%s.%s", eventBinding.key(), definition.getCode()), eventBinding.exchange() != null ? eventBinding.exchange().name() : null, eventBinding.exchange() != null ? eventBinding.exchange().type() : null, eventBinding.queue() != null ? eventBinding.queue().name() : null, argumentsMap);
        return eventBindingContext;
    }

    default public String getListenerKey(EventListener eventListener) {
        return StrUtil.isNotEmpty((CharSequence)eventListener.key()) ? eventListener.key() : null;
    }

    default public String getRoutingKey(EventListener eventListener) {
        String routingKey = this.getListenerKey(eventListener);
        return String.format("%s.%s", routingKey, eventListener.definition().getCode());
    }

    default public List<String> getListenerKeys(EventListener eventListener) {
        List<EventBindingContext> eventBindingContextList = this.buildEventBindingsContexts(eventListener, null, null);
        if (CollectionUtil.isNotEmpty(eventBindingContextList)) {
            return eventBindingContextList.stream().map(EventBindingContext::getRoutingKey).collect(Collectors.toList());
        }
        String defaultListenerKey = this.getRoutingKey(eventListener);
        return Arrays.asList(defaultListenerKey);
    }

    public List<EventBindingContext> buildEventBindingsContexts(EventListener var1, String var2, String var3);

    public EventBindingContext buildEventBindingsContext(EventPublisher var1);
}

