/*
 * Decompiled with CFR 0.152.
 */
package cn.amossun.starter.event;

import cn.amossun.starter.event.endpoint.EventContextEndpoint;
import cn.amossun.starter.event.handler.EventBindingContextProcessor;
import cn.amossun.starter.event.handler.EventBindingInitializer;
import cn.amossun.starter.event.handler.EventContextHolder;
import cn.amossun.starter.event.handler.EventContextProcessor;
import cn.amossun.starter.event.handler.EventExchangeContextProcessor;
import cn.amossun.starter.event.handler.EventExchangeInitializer;
import cn.amossun.starter.event.handler.EventQueueContextProcessor;
import cn.amossun.starter.event.handler.EventQueuesInitializer;
import cn.amossun.starter.event.handler.ListenerContainerInitializer;
import cn.amossun.starter.event.handler.ListenerContextProcessor;
import cn.amossun.starter.event.handler.ListenerInvokeHolder;
import cn.amossun.starter.event.handler.SimpleMulticasterAspect;
import cn.amossun.starter.event.handler.SimplePublisherAspect;
import cn.amossun.starter.event.listener.SimpleRemoteEventMessageListener;
import cn.amossun.starter.event.property.EventContext;
import cn.amossun.starter.event.property.ListenerContext;
import java.net.InetAddress;
import java.net.UnknownHostException;
import java.util.ArrayList;
import java.util.List;
import org.springframework.amqp.rabbit.config.DirectRabbitListenerContainerFactory;
import org.springframework.amqp.rabbit.config.SimpleRabbitListenerContainerFactory;
import org.springframework.amqp.rabbit.connection.CachingConnectionFactory;
import org.springframework.amqp.rabbit.connection.ConnectionFactory;
import org.springframework.amqp.rabbit.core.RabbitAdmin;
import org.springframework.amqp.rabbit.core.RabbitTemplate;
import org.springframework.amqp.support.converter.Jackson2JsonMessageConverter;
import org.springframework.amqp.support.converter.MessageConverter;
import org.springframework.beans.factory.annotation.Qualifier;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.boot.autoconfigure.amqp.DirectRabbitListenerContainerFactoryConfigurer;
import org.springframework.boot.autoconfigure.amqp.SimpleRabbitListenerContainerFactoryConfigurer;
import org.springframework.boot.autoconfigure.condition.ConditionalOnMissingBean;
import org.springframework.boot.autoconfigure.condition.ConditionalOnProperty;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;
import org.springframework.context.annotation.DependsOn;
import org.springframework.core.env.Environment;

@Configuration
public class EventAutoConfiguration {
    @Value(value="${spring.application.name}")
    private String service;

    @Bean(name={"instance"})
    String instance(Environment environment) throws UnknownHostException {
        return String.format("%s:%s:%s", InetAddress.getLocalHost().getHostAddress(), this.service, environment.getProperty("server.port"));
    }

    @Bean
    EventContext eventContext() {
        return new EventContext();
    }

    @Bean
    EventQueueContextProcessor eventQueueContextProcessor(EventContext eventContext) {
        return new EventQueueContextProcessor(eventContext);
    }

    @Bean
    EventExchangeContextProcessor eventExchangeContextProcessor(EventContext eventContext) {
        return new EventExchangeContextProcessor(eventContext);
    }

    @Bean
    EventBindingContextProcessor eventBindingContextProcessor(EventContext eventContext, EventQueueContextProcessor eventQueueContextProcessor, EventExchangeContextProcessor eventExchangeContextProcessor) {
        return new EventBindingContextProcessor(eventContext, eventQueueContextProcessor, eventExchangeContextProcessor);
    }

    @Bean(value={"listenerContextProcessor"})
    ListenerInvokeHolder<ListenerContext> listenerContextProcessor(EventContext eventContext, @Qualifier(value="eventRabbitAdmin") RabbitAdmin rabbitAdmin) {
        return new ListenerContextProcessor(eventContext, rabbitAdmin);
    }

    @Bean(value={"eventContextProcessor"})
    EventContextProcessor eventContextProcessor(EventContext eventContext, final EventQueueContextProcessor eventQueueContextProcessor, final EventExchangeContextProcessor eventExchangeContextProcessor, final EventBindingContextProcessor eventBindingContextProcessor, @Qualifier(value="listenerContextProcessor") ListenerInvokeHolder<ListenerContext> listenerContextProcessor) {
        ArrayList<EventContextHolder> eventContextHolderList = new ArrayList<EventContextHolder>(){
            {
                this.add(eventQueueContextProcessor);
                this.add(eventExchangeContextProcessor);
                this.add(eventBindingContextProcessor);
            }
        };
        return new EventContextProcessor(eventContext, eventQueueContextProcessor, eventBindingContextProcessor, (List<EventContextHolder>)eventContextHolderList, listenerContextProcessor);
    }

    @Bean
    EventContextEndpoint eventContextEndpoint(EventContext eventContext) {
        return new EventContextEndpoint(eventContext);
    }

    @ConditionalOnProperty(prefix="event.multicast", name={"enabled"})
    static class EventMulticastConfig {
        EventMulticastConfig() {
        }

        @ConditionalOnMissingBean
        @ConditionalOnProperty(prefix="event", name={"remoteType"}, havingValue="rabbitmq")
        @Bean(value={"simpleMulticasterAspect"})
        SimpleMulticasterAspect simpleMulticasterAspect() {
            return new SimpleMulticasterAspect();
        }
    }

    @ConditionalOnProperty(prefix="event.publisher", name={"enabled"})
    static class EventPublisherConfig {
        EventPublisherConfig() {
        }

        @ConditionalOnMissingBean
        @ConditionalOnProperty(prefix="event", name={"remoteType"}, havingValue="rabbitmq")
        @Bean(value={"simplePublisherAspect"})
        SimplePublisherAspect simplePublisherAspect() {
            return new SimplePublisherAspect();
        }
    }

    @ConditionalOnProperty(prefix="event.listener", name={"enabled"})
    class EventListenerConfig {
        EventListenerConfig() {
        }

        @ConditionalOnMissingBean
        @ConditionalOnProperty(prefix="event", name={"remoteType"}, havingValue="rabbitmq", matchIfMissing=true)
        @DependsOn(value={"eventContext"})
        @Bean
        SimpleRemoteEventMessageListener simpleRemoteEventMessageListener(EventContext eventContext) {
            return new SimpleRemoteEventMessageListener(eventContext);
        }
    }

    @ConditionalOnProperty(prefix="event", name={"remoteType"}, havingValue="rabbitmq")
    static class RabbitMQConfig {
        @Value(value="${event.rabbitmq.username}")
        String userName;
        @Value(value="${event.rabbitmq.password}")
        String password;
        @Value(value="${event.rabbitmq.host}")
        String host;
        @Value(value="${event.rabbitmq.port}")
        int port;
        @Value(value="${event.rabbitmq.virtual-host}")
        String virtualHost;
        @Value(value="${event.rabbitmq.prefetch-count:50}")
        Integer prefetchCount;

        RabbitMQConfig() {
        }

        @Bean(name={"eventConnectionFactory"})
        CachingConnectionFactory cachingConnectionFactory() {
            CachingConnectionFactory cachingConnectionFactory = new CachingConnectionFactory();
            cachingConnectionFactory.setUsername(this.userName);
            cachingConnectionFactory.setPassword(this.password);
            cachingConnectionFactory.setHost(this.host);
            cachingConnectionFactory.setPort(this.port);
            cachingConnectionFactory.setVirtualHost(this.virtualHost);
            cachingConnectionFactory.setPublisherConfirms(true);
            return cachingConnectionFactory;
        }

        @Bean(name={"eventSimpleRabbitListenerContainerFactory"})
        @ConditionalOnMissingBean(name={"eventSimpleRabbitListenerContainerFactory"})
        SimpleRabbitListenerContainerFactory rabbitListenerContainerFactory(SimpleRabbitListenerContainerFactoryConfigurer configurer) {
            SimpleRabbitListenerContainerFactory factory = new SimpleRabbitListenerContainerFactory();
            factory.setMessageConverter((MessageConverter)new Jackson2JsonMessageConverter());
            configurer.configure(factory, (ConnectionFactory)this.cachingConnectionFactory());
            return factory;
        }

        @Bean(name={"eventDirectRabbitListenerContainerFactory"})
        @ConditionalOnMissingBean(name={"eventDirectRabbitListenerContainerFactory"})
        DirectRabbitListenerContainerFactory rabbitListenerContainerFactory(DirectRabbitListenerContainerFactoryConfigurer configurer) {
            DirectRabbitListenerContainerFactory factory = new DirectRabbitListenerContainerFactory();
            factory.setMessageConverter((MessageConverter)new Jackson2JsonMessageConverter());
            configurer.configure(factory, (ConnectionFactory)this.cachingConnectionFactory());
            return factory;
        }

        @Bean(name={"eventRabbitTemplate"})
        RabbitTemplate rabbitTemplate(@Qualifier(value="eventConnectionFactory") CachingConnectionFactory cachingConnectionFactory) {
            return new RabbitTemplate((ConnectionFactory)cachingConnectionFactory);
        }

        @Bean(name={"eventRabbitAdmin"})
        RabbitAdmin rabbitAdmin(@Qualifier(value="eventRabbitTemplate") RabbitTemplate rabbitTemplate) {
            return new RabbitAdmin(rabbitTemplate);
        }

        @DependsOn(value={"eventContextProcessor", "eventRabbitAdmin"})
        @Bean(value={"eventQueuesInitializer"})
        EventQueuesInitializer eventQueuesInitializer(EventContext eventContext, @Qualifier(value="eventRabbitAdmin") RabbitAdmin rabbitAdmin) {
            return new EventQueuesInitializer(eventContext, rabbitAdmin);
        }

        @DependsOn(value={"eventContextProcessor", "eventRabbitAdmin"})
        @Bean(value={"eventExchangeInitializer"})
        EventExchangeInitializer eventExchangeInitializer(EventContext eventContext, @Qualifier(value="eventRabbitAdmin") RabbitAdmin rabbitAdmin) {
            return new EventExchangeInitializer(eventContext, rabbitAdmin);
        }

        @DependsOn(value={"eventQueuesInitializer", "eventExchangeInitializer"})
        @Bean
        EventBindingInitializer eventBindingInitializer(EventContext eventContext, @Qualifier(value="eventRabbitAdmin") RabbitAdmin rabbitAdmin) {
            return new EventBindingInitializer(eventContext, rabbitAdmin);
        }

        @ConditionalOnProperty(prefix="event.listener", name={"enabled"}, havingValue="true")
        @Bean
        ListenerContainerInitializer eventListenerContainerInitializer(EventContext eventContext, SimpleRemoteEventMessageListener simpleRemoteEventMessageListener, SimpleRabbitListenerContainerFactory simpleRabbitListenerContainerFactory) {
            return new ListenerContainerInitializer(eventContext, this.prefetchCount, simpleRemoteEventMessageListener, this.cachingConnectionFactory(), simpleRabbitListenerContainerFactory);
        }
    }
}

