/*
 * Decompiled with CFR 0.152.
 */
package cn.allbs.job.config;

import cn.allbs.job.annotation.XxlJobAuto;
import cn.allbs.job.model.XxlJobGroup;
import cn.allbs.job.model.XxlJobInfo;
import cn.allbs.job.service.JobGroupService;
import cn.allbs.job.service.JobInfoService;
import cn.hutool.core.collection.CollUtil;
import com.xxl.job.core.handler.annotation.XxlJob;
import java.lang.reflect.AnnotatedElement;
import java.lang.reflect.Method;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.concurrent.TimeUnit;
import javax.annotation.Resource;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.BeansException;
import org.springframework.boot.autoconfigure.EnableAutoConfiguration;
import org.springframework.boot.context.event.ApplicationReadyEvent;
import org.springframework.context.ApplicationContext;
import org.springframework.context.ApplicationContextAware;
import org.springframework.context.ApplicationListener;
import org.springframework.context.annotation.Configuration;
import org.springframework.core.MethodIntrospector;
import org.springframework.core.annotation.AnnotatedElementUtils;
import org.springframework.util.StringUtils;

@Configuration(proxyBeanMethods=false)
@EnableAutoConfiguration
public class XxlJobAutoRegister
implements ApplicationListener<ApplicationReadyEvent>,
ApplicationContextAware {
    private static final Logger log = LoggerFactory.getLogger(XxlJobAutoRegister.class);
    @Resource
    private JobGroupService jobGroupService;
    @Resource
    private JobInfoService jobInfoService;
    private ApplicationContext applicationContext;

    public void setApplicationContext(ApplicationContext applicationContext) throws BeansException {
        this.applicationContext = applicationContext;
    }

    public void onApplicationEvent(ApplicationReadyEvent event) {
        this.addJobGroup();
        this.addJobInfo();
    }

    private void addJobGroup() {
        if (this.jobGroupService.preciselyCheck()) {
            return;
        }
        if (this.jobGroupService.autoRegisterGroup()) {
            log.info("auto register xxl-job group success!");
        }
    }

    private void addJobInfo() {
        String[] beanDefinitionNames;
        List<XxlJobGroup> jobGroups = this.jobGroupService.getJobGroup();
        if (CollUtil.isEmpty(jobGroups)) {
            log.error("\u6267\u884c\u5668\u4e0d\u5b58\u5728\uff0c\u81ea\u52a8\u6ce8\u518c\u5931\u8d25!");
        }
        XxlJobGroup xxlJobGroup = jobGroups.get(0);
        for (String beanDefinitionName : beanDefinitionNames = this.applicationContext.getBeanNamesForType(Object.class, false, true)) {
            Object bean = this.applicationContext.getBean(beanDefinitionName);
            Map annotatedMethods = MethodIntrospector.selectMethods(bean.getClass(), method -> (XxlJob)AnnotatedElementUtils.findMergedAnnotation((AnnotatedElement)method, XxlJob.class));
            for (Map.Entry methodXxlJobEntry : annotatedMethods.entrySet()) {
                Optional<XxlJobInfo> first;
                Method executeMethod = (Method)methodXxlJobEntry.getKey();
                XxlJob xxlJob = (XxlJob)methodXxlJobEntry.getValue();
                if (!executeMethod.isAnnotationPresent(XxlJobAuto.class)) continue;
                XxlJobAuto xxlJobAuto = executeMethod.getAnnotation(XxlJobAuto.class);
                List<XxlJobInfo> jobInfo = this.jobInfoService.getJobInfo(xxlJobGroup.getId(), xxlJob.value());
                if (!jobInfo.isEmpty() && (first = jobInfo.stream().filter(xxlJobInfo -> xxlJobInfo.getExecutorHandler().equals(xxlJob.value())).findFirst()).isPresent()) continue;
                XxlJobInfo xxlJobInfo2 = this.createXxlJobInfo(xxlJobGroup, xxlJob, xxlJobAuto);
                Integer n = this.jobInfoService.addJobInfo(xxlJobInfo2);
            }
        }
    }

    private XxlJobInfo createXxlJobInfo(XxlJobGroup xxlJobGroup, XxlJob xxlJob, XxlJobAuto xxlJobAuto) {
        XxlJobInfo xxlJobInfo = new XxlJobInfo();
        xxlJobInfo.setJobGroup(xxlJobGroup.getId());
        xxlJobInfo.setJobDesc(xxlJobAuto.jobDesc());
        xxlJobInfo.setAuthor(xxlJobAuto.author());
        if (StringUtils.hasText((String)xxlJobAuto.cron())) {
            xxlJobInfo.setScheduleType("CRON");
            xxlJobInfo.setScheduleConf(xxlJobAuto.cron());
        } else {
            xxlJobInfo.setScheduleType("FIX_RATE");
            xxlJobInfo.setScheduleConf(String.valueOf(TimeUnit.SECONDS.convert(xxlJobAuto.scheduleConf(), xxlJobAuto.timeUnit())));
        }
        xxlJobInfo.setGlueType("BEAN");
        xxlJobInfo.setExecutorHandler(xxlJob.value());
        xxlJobInfo.setExecutorRouteStrategy(xxlJobAuto.executorRouteStrategy());
        xxlJobInfo.setMisfireStrategy(xxlJobAuto.misfireStrategy());
        xxlJobInfo.setExecutorBlockStrategy("SERIAL_EXECUTION");
        xxlJobInfo.setExecutorTimeout(xxlJobAuto.executorTimeout());
        xxlJobInfo.setExecutorFailRetryCount(xxlJobAuto.executorFailRetryCount());
        xxlJobInfo.setGlueRemark("GLUE\u4ee3\u7801\u521d\u59cb\u5316");
        xxlJobInfo.setTriggerStatus(xxlJobAuto.triggerStatus());
        xxlJobInfo.setExecutorParam(xxlJobInfo.getExecutorParam());
        return xxlJobInfo;
    }
}

