/*
 * Decompiled with CFR 0.152.
 */
package cn.allbs.job.service.impl;

import cn.allbs.job.properties.XxlJobProperties;
import cn.allbs.job.service.JobLoginService;
import cn.hutool.http.HttpRequest;
import cn.hutool.http.HttpResponse;
import java.net.HttpCookie;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import javax.annotation.Resource;
import org.springframework.boot.context.properties.EnableConfigurationProperties;
import org.springframework.stereotype.Service;

@Service
@EnableConfigurationProperties(value={XxlJobProperties.class})
public class JobLoginServiceImpl
implements JobLoginService {
    @Resource
    private XxlJobProperties xxlJobProperties;
    private final Map<String, String> loginCookie = new HashMap<String, String>();

    @Override
    public void login() {
        String url = this.xxlJobProperties.getAdmin().getAddress() + "login";
        HttpResponse response = HttpRequest.post((String)url).form("userName", (Object)this.xxlJobProperties.getAdmin().getUsername()).form("password", (Object)this.xxlJobProperties.getAdmin().getPassword()).execute();
        List cookies = response.getCookies();
        Optional<HttpCookie> cookieOpt = cookies.stream().filter(cookie -> cookie.getName().equals("XXL_JOB_LOGIN_IDENTITY")).findFirst();
        if (!cookieOpt.isPresent()) {
            throw new RuntimeException("get xxl-job cookie error!");
        }
        String value = cookieOpt.get().getValue();
        this.loginCookie.put("XXL_JOB_LOGIN_IDENTITY", value);
    }

    @Override
    public String getCookie() {
        for (int i = 0; i < 3; ++i) {
            String cookieStr = this.loginCookie.get("XXL_JOB_LOGIN_IDENTITY");
            if (cookieStr != null) {
                return "XXL_JOB_LOGIN_IDENTITY=" + cookieStr;
            }
            this.login();
        }
        throw new RuntimeException("get xxl-job cookie error!");
    }
}

