/*
 * Decompiled with CFR 0.152.
 */
package cn.allbs.job.service.impl;

import cn.allbs.job.model.XxlJobGroup;
import cn.allbs.job.properties.XxlJobProperties;
import cn.allbs.job.service.JobGroupService;
import cn.allbs.job.service.JobLoginService;
import cn.hutool.http.HttpRequest;
import cn.hutool.http.HttpResponse;
import cn.hutool.json.JSONArray;
import cn.hutool.json.JSONObject;
import cn.hutool.json.JSONUtil;
import java.time.LocalDate;
import java.time.format.DateTimeFormatter;
import java.util.List;
import java.util.Optional;
import java.util.stream.Collectors;
import javax.annotation.Resource;
import org.springframework.boot.autoconfigure.AutoConfigureAfter;
import org.springframework.boot.context.properties.EnableConfigurationProperties;
import org.springframework.stereotype.Service;
import org.springframework.util.StringUtils;

@Service
@AutoConfigureAfter(value={JobLoginService.class})
@EnableConfigurationProperties(value={XxlJobProperties.class})
public class JobGroupServiceImpl
implements JobGroupService {
    @Resource
    private XxlJobProperties xxlJobProperties;
    @Resource
    private JobLoginService jobLoginService;

    @Override
    public List<XxlJobGroup> getJobGroup() {
        String url = this.xxlJobProperties.getAdmin().getAddress() + "jobgroup/pageList";
        HttpResponse response = HttpRequest.post((String)url).form("appname", (Object)this.xxlJobProperties.getExecutor().getAppname()).cookie(this.jobLoginService.getCookie()).execute();
        String body = response.body();
        JSONArray array = (JSONArray)JSONUtil.parse((Object)body).getByPath("data", JSONArray.class);
        List<XxlJobGroup> list = array.stream().map(o -> (XxlJobGroup)JSONUtil.toBean((JSONObject)((JSONObject)o), XxlJobGroup.class)).collect(Collectors.toList());
        return list;
    }

    @Override
    public boolean autoRegisterGroup() {
        String url = this.xxlJobProperties.getAdmin().getAddress() + "jobgroup/save";
        HttpRequest httpRequest = HttpRequest.post((String)url).form("appname", (Object)this.xxlJobProperties.getExecutor().getAppname()).form("title", (Object)(LocalDate.now().format(DateTimeFormatter.ofPattern("yyyyMMdd")) + "\u6ce8\u518c"));
        httpRequest.form("addressType", (Object)this.xxlJobProperties.getExecutor().getAutoRegister());
        if (this.xxlJobProperties.getExecutor().getAutoRegister().equals(1)) {
            if (!StringUtils.hasText((String)this.xxlJobProperties.getExecutor().getManualAddressList())) {
                throw new RuntimeException("\u624b\u52a8\u5f55\u5165\u6a21\u5f0f\u4e0b,\u6267\u884c\u5668\u5730\u5740\u5217\u8868\u4e0d\u80fd\u4e3a\u7a7a");
            }
            httpRequest.form("addressList", (Object)this.xxlJobProperties.getExecutor().getManualAddressList());
        }
        HttpResponse response = httpRequest.cookie(this.jobLoginService.getCookie()).execute();
        Object code = JSONUtil.parse((Object)response.body()).getByPath("code");
        return code.equals(200);
    }

    @Override
    public boolean preciselyCheck() {
        List<XxlJobGroup> jobGroup = this.getJobGroup();
        Optional<XxlJobGroup> has = jobGroup.stream().filter(xxlJobGroup -> xxlJobGroup.getAppname().equals(this.xxlJobProperties.getExecutor().getAppname())).findAny();
        return has.isPresent();
    }
}

