/*
 * Decompiled with CFR 0.152.
 */
package cn.allbs.xss.core;

import cn.allbs.xss.XssProperties;
import cn.allbs.xss.core.XssHolder;
import cn.allbs.xss.core.XssIgnore;
import cn.allbs.xss.utils.XssUtil;
import java.lang.reflect.Method;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.springframework.core.annotation.AnnotationUtils;
import org.springframework.http.HttpMethod;
import org.springframework.web.method.HandlerMethod;
import org.springframework.web.servlet.AsyncHandlerInterceptor;

public class XssCleanInterceptor
implements AsyncHandlerInterceptor {
    private final XssProperties xssProperties;

    public boolean preHandle(HttpServletRequest request, HttpServletResponse response, Object handler) throws Exception {
        if (!this.xssProperties.isEnabled()) {
            return true;
        }
        if (!(handler instanceof HandlerMethod)) {
            return true;
        }
        if (!XssUtil.equalsAnyIgnoreCase(request.getMethod(), HttpMethod.POST.name(), HttpMethod.PUT.name())) {
            return true;
        }
        HandlerMethod handlerMethod = (HandlerMethod)handler;
        XssIgnore xssIgnore = (XssIgnore)AnnotationUtils.findAnnotation((Method)handlerMethod.getMethod(), XssIgnore.class);
        if (xssIgnore == null) {
            XssHolder.setEnable();
        }
        return true;
    }

    public void afterCompletion(HttpServletRequest request, HttpServletResponse response, Object handler, Exception ex) throws Exception {
        XssHolder.remove();
    }

    public void afterConcurrentHandlingStarted(HttpServletRequest request, HttpServletResponse response, Object handler) throws Exception {
        XssHolder.remove();
    }

    public XssCleanInterceptor(XssProperties xssProperties) {
        this.xssProperties = xssProperties;
    }
}

