/*
 * Decompiled with CFR 0.152.
 */
package cn.allbs.xss.core;

import cn.allbs.xss.core.XssHolder;
import cn.allbs.xss.utils.XssUtil;
import java.beans.PropertyEditor;
import java.beans.PropertyEditorSupport;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.web.bind.WebDataBinder;
import org.springframework.web.bind.annotation.ControllerAdvice;
import org.springframework.web.bind.annotation.InitBinder;

@ControllerAdvice
public class FormXssClean {
    @InitBinder
    public void initBinder(WebDataBinder binder) {
        binder.registerCustomEditor(String.class, (PropertyEditor)new StringPropertiesEditor());
    }

    public static class StringPropertiesEditor
    extends PropertyEditorSupport {
        private static final Logger log = LoggerFactory.getLogger(StringPropertiesEditor.class);

        @Override
        public String getAsText() {
            Object value = this.getValue();
            return value != null ? value.toString() : "";
        }

        @Override
        public void setAsText(String text) throws IllegalArgumentException {
            if (text == null) {
                this.setValue(null);
            } else if (XssHolder.isEnabled()) {
                String value = XssUtil.clean(text);
                this.setValue(value);
            } else {
                this.setValue(text);
            }
        }
    }
}

