package cn.allbs.xss;

import cn.allbs.xss.utils.XssUtil;
import lombok.Getter;
import lombok.Setter;
import org.springframework.beans.factory.InitializingBean;
import org.springframework.boot.context.properties.ConfigurationProperties;

import java.util.ArrayList;
import java.util.List;

/**
 * 功能: xss配置
 *
 * @author ChenQi
 * @version 1.0
 * @since 2021/3/31
 */
@Getter
@Setter
@ConfigurationProperties("security.xss")
public class XssProperties implements InitializingBean {

    /**
     * 开启xss
     */
    private boolean enabled = true;

    /**
     * 拦截的路由，默认拦截 /**
     */
    private List<String> pathPatterns = new ArrayList<>();

    /**
     * 放行的规则，默认为空
     */
    private List<String> excludePatterns = new ArrayList<>();

    @Override
    public void afterPropertiesSet() {
        if (XssUtil.isEmpty(pathPatterns)) {
            pathPatterns.add("/**");
        }
    }

}
