/*
 * Decompiled with CFR 0.152.
 */
package cn.allbs.xss.core;

import cn.allbs.xss.core.XssHolder;
import cn.allbs.xss.utils.XssUtil;
import com.fasterxml.jackson.core.JsonParser;
import com.fasterxml.jackson.databind.DeserializationContext;
import com.fasterxml.jackson.databind.JsonDeserializer;
import java.io.IOException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class JacksonXssClean
extends JsonDeserializer<String> {
    private static final Logger log = LoggerFactory.getLogger(JacksonXssClean.class);

    public String deserialize(JsonParser p, DeserializationContext ctxt) throws IOException {
        String text = p.getValueAsString();
        if (text == null) {
            return null;
        }
        if (XssHolder.isEnabled()) {
            String value = XssUtil.clean(text);
            log.trace("Json property value:{}, current value is:{}.", (Object)text, (Object)value);
            return value;
        }
        return text;
    }
}

