package cn.allbs.xss.core;

import cn.allbs.xss.utils.XssUtil;
import cn.hutool.core.util.StrUtil;
import lombok.extern.slf4j.Slf4j;
import org.springframework.web.bind.WebDataBinder;
import org.springframework.web.bind.annotation.ControllerAdvice;
import org.springframework.web.bind.annotation.InitBinder;

import java.beans.PropertyEditorSupport;

/**
 * 功能:
 *
 * @author ChenQi
 * @version 1.0
 * @since 2021/3/31
 */
@ControllerAdvice
public class FormXssClean {

    @InitBinder
    public void initBinder(WebDataBinder binder) {
        // 处理前端传来的表单字符串
        binder.registerCustomEditor(String.class, new StringPropertiesEditor());
    }

    @Slf4j
    public static class StringPropertiesEditor extends PropertyEditorSupport {

        @Override
        public String getAsText() {
            Object value = getValue();
            return value != null ? value.toString() : StrUtil.EMPTY;
        }

        @Override
        public void setAsText(String text) throws IllegalArgumentException {
            if (text == null) {
                setValue(null);
            }
            else if (XssHolder.isEnabled()) {
                String value = XssUtil.clean(text);
                setValue(value);
            }
            else {
                setValue(text);
            }
        }

    }

}
