/*
 * Decompiled with CFR 0.152.
 */
package cn.allbs.xss;

import cn.allbs.xss.XssProperties;
import cn.allbs.xss.core.FormXssClean;
import cn.allbs.xss.core.JacksonXssClean;
import cn.allbs.xss.core.XssCleanInterceptor;
import com.fasterxml.jackson.databind.JsonDeserializer;
import org.springframework.boot.autoconfigure.condition.ConditionalOnProperty;
import org.springframework.boot.autoconfigure.jackson.Jackson2ObjectMapperBuilderCustomizer;
import org.springframework.boot.context.properties.EnableConfigurationProperties;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;
import org.springframework.web.servlet.HandlerInterceptor;
import org.springframework.web.servlet.config.annotation.InterceptorRegistry;
import org.springframework.web.servlet.config.annotation.WebMvcConfigurer;

@Configuration(proxyBeanMethods=false)
@EnableConfigurationProperties(value={XssProperties.class})
@ConditionalOnProperty(value={"security.xss.enabled"}, havingValue="true", matchIfMissing=true)
public class XssAutoConfiguration
implements WebMvcConfigurer {
    private final XssProperties xssProperties;

    @Bean
    public FormXssClean formXssClean() {
        return new FormXssClean();
    }

    @Bean
    public Jackson2ObjectMapperBuilderCustomizer xssJacksonCustomizer() {
        return builder -> builder.deserializerByType(String.class, (JsonDeserializer)new JacksonXssClean());
    }

    public void addInterceptors(InterceptorRegistry registry) {
        XssCleanInterceptor interceptor = new XssCleanInterceptor(this.xssProperties);
        registry.addInterceptor((HandlerInterceptor)interceptor).addPathPatterns(this.xssProperties.getPathPatterns()).excludePathPatterns(this.xssProperties.getExcludePatterns()).order(Integer.MAX_VALUE);
    }

    public XssAutoConfiguration(XssProperties xssProperties) {
        this.xssProperties = xssProperties;
    }
}

