package cn.allbs.websocket.handler;

import cn.allbs.common.enums.WebSocketResponseEnum;
import cn.allbs.websocket.behavior.AuthRequest;
import cn.allbs.websocket.behavior.AuthResponse;
import cn.allbs.websocket.behavior.UserJoinNoticeRequest;
import cn.allbs.websocket.exception.MessageHandlerException;
import cn.allbs.websocket.message.MessageFactory;
import cn.allbs.websocket.util.WebSocketUtil;
import cn.hutool.core.util.StrUtil;
import org.springframework.beans.factory.InitializingBean;
import org.springframework.web.socket.WebSocketSession;

import static cn.allbs.websocket.enums.MessageType.AUTH_REQUEST;

/**
 * 用户权限校验
 *
 * @author ChenQi
 */
public abstract class AuthMessageHandler implements MessageHandler<AuthRequest>, InitializingBean {

    @Override
    public void execute(WebSocketSession session, AuthRequest message) {
        // 如果未传递userName
        if (StrUtil.isEmpty(message.getUserName())) {
            throw new MessageHandlerException("websocket连接失败,未指定参数userName!");
        }
        WebSocketUtil.addSession(session, message.getUserName());
        WebSocketUtil.send(session, WebSocketResponseEnum.AUTH_SUCCESS, AuthResponse.builder().content(StrUtil.format("连接成功")).build());
        UserJoinNoticeRequest joinRequest = UserJoinNoticeRequest.builder().userName(message.getUserName()).message(StrUtil.format("{}用户连接成功", message.getUserName())).build();
        WebSocketUtil.broadcastWithoutSelf(WebSocketResponseEnum.JOIN_ONLINE, joinRequest, message.getUserName());
    }

    @Override
    public void afterPropertiesSet() {
        MessageFactory.register(AUTH_REQUEST.name(), this);
    }

}
