/*
 * Decompiled with CFR 0.152.
 */
package cn.allbs.websocket.handler;

import cn.allbs.common.enums.WebSocketResponseEnum;
import cn.allbs.websocket.behavior.AuthRequest;
import cn.allbs.websocket.behavior.AuthResponse;
import cn.allbs.websocket.behavior.UserJoinNoticeRequest;
import cn.allbs.websocket.enums.MessageType;
import cn.allbs.websocket.exception.MessageHandlerException;
import cn.allbs.websocket.handler.MessageHandler;
import cn.allbs.websocket.message.MessageFactory;
import cn.allbs.websocket.util.WebSocketUtil;
import cn.hutool.core.util.StrUtil;
import org.springframework.beans.factory.InitializingBean;
import org.springframework.web.socket.WebSocketSession;

public abstract class AuthMessageHandler
implements MessageHandler<AuthRequest>,
InitializingBean {
    @Override
    public void execute(WebSocketSession session, AuthRequest message) {
        if (StrUtil.isEmpty((CharSequence)message.getUserName())) {
            throw new MessageHandlerException("websocket\u8fde\u63a5\u5931\u8d25,\u672a\u6307\u5b9a\u53c2\u6570userName!");
        }
        WebSocketUtil.addSession(session, message.getUserName());
        WebSocketUtil.send(session, WebSocketResponseEnum.AUTH_SUCCESS, AuthResponse.builder().content(StrUtil.format((CharSequence)"\u8fde\u63a5\u6210\u529f", (Object[])new Object[0])).build());
        UserJoinNoticeRequest joinRequest = UserJoinNoticeRequest.builder().userName(message.getUserName()).message(StrUtil.format((CharSequence)"{}\u7528\u6237\u8fde\u63a5\u6210\u529f", (Object[])new Object[]{message.getUserName()})).build();
        WebSocketUtil.broadcastWithoutSelf(WebSocketResponseEnum.JOIN_ONLINE, joinRequest, message.getUserName());
    }

    public void afterPropertiesSet() {
        MessageFactory.register(MessageType.AUTH_REQUEST.name(), this);
    }
}

