/*
 * Decompiled with CFR 0.152.
 */
package cn.allbs.websocket.handler;

import cn.hutool.core.date.DateUtil;
import cn.hutool.core.util.StrUtil;
import cn.hutool.http.HttpUtil;
import java.nio.charset.Charset;
import java.util.Map;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.http.server.ServerHttpRequest;
import org.springframework.http.server.ServerHttpResponse;
import org.springframework.http.server.ServletServerHttpRequest;
import org.springframework.web.socket.WebSocketHandler;
import org.springframework.web.socket.server.support.HttpSessionHandshakeInterceptor;

public class AllbsWebSocketShakeInterceptor
extends HttpSessionHandshakeInterceptor {
    private static final Logger log = LoggerFactory.getLogger(AllbsWebSocketShakeInterceptor.class);

    public boolean beforeHandshake(ServerHttpRequest request, ServerHttpResponse response, WebSocketHandler wsHandler, Map<String, Object> attributes) throws Exception {
        log.debug("websocket \u63e1\u624b\u5f00\u59cb");
        if (request instanceof ServletServerHttpRequest) {
            Map paramMap = HttpUtil.decodeParamMap((String)request.getURI().getQuery(), (Charset)Charset.defaultCharset());
            String accessToken = (String)paramMap.get("accessToken");
            String userName = (String)paramMap.get("userName");
            if (StrUtil.isAllNotEmpty((CharSequence[])new CharSequence[]{accessToken, userName})) {
                attributes.put("accessToken", accessToken);
                attributes.put("userName", userName);
                log.debug(DateUtil.now() + "\u5730\u5740\uff1a" + request.getRemoteAddress() + " accessToken: " + accessToken + " \u7684\u7528\u6237" + userName + "\u63e1\u624b\u6210\u529f\uff01");
                log.debug("websocket \u8fde\u63a5\u6210\u529f");
                return true;
            }
        }
        log.debug("websocket \u8fde\u63a5\u5931\u8d25");
        return false;
    }

    public void afterHandshake(ServerHttpRequest request, ServerHttpResponse response, WebSocketHandler wsHandler, Exception exception) {
        log.debug("websocket \u63e1\u624b\u5b8c\u6210");
    }
}

