/*
 * Decompiled with CFR 0.152.
 */
package cn.allbs.websocket.handler;

import cn.allbs.common.enums.WebSocketResponseEnum;
import cn.allbs.common.utils.ObjectUtil;
import cn.allbs.websocket.behavior.AuthRequest;
import cn.allbs.websocket.behavior.SysDefaultRequest;
import cn.allbs.websocket.behavior.UserJoinNoticeRequest;
import cn.allbs.websocket.enums.MessageType;
import cn.allbs.websocket.exception.MessageHandlerException;
import cn.allbs.websocket.message.Message;
import cn.allbs.websocket.message.MessageFactory;
import cn.allbs.websocket.util.WebSocketUtil;
import cn.hutool.core.bean.BeanUtil;
import cn.hutool.core.util.ClassUtil;
import cn.hutool.core.util.StrUtil;
import cn.hutool.json.JSONObject;
import cn.hutool.json.JSONUtil;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.aop.framework.AopProxyUtils;
import org.springframework.web.socket.CloseStatus;
import org.springframework.web.socket.TextMessage;
import org.springframework.web.socket.WebSocketSession;
import org.springframework.web.socket.handler.TextWebSocketHandler;

public class AllbsWebSocketHandler
extends TextWebSocketHandler {
    private static final Logger log = LoggerFactory.getLogger(AllbsWebSocketHandler.class);

    public void afterConnectionEstablished(WebSocketSession session) throws MessageHandlerException {
        log.debug("[afterConnectionEstablished][session({}) \u63a5\u5165]", (Object)session);
        String accessToken = (String)session.getAttributes().get("accessToken");
        String userName = (String)session.getAttributes().get("userName");
        AuthRequest authRequest = AuthRequest.builder().accessToken(accessToken).userName(userName).build();
        MessageFactory.getInvokeStrategy(MessageType.AUTH_REQUEST.name()).execute(session, authRequest);
    }

    public void handleTextMessage(WebSocketSession session, TextMessage textMessage) {
        log.debug("[handleMessage][session({}) \u63a5\u6536\u5230\u4e00\u6761\u6d88\u606f({})]", (Object)session, (Object)textMessage);
        try {
            JSONObject jsonObject;
            if (JSONUtil.isJson((String)((String)textMessage.getPayload())) && (jsonObject = JSONUtil.parseObj((String)((String)textMessage.getPayload()))).containsKey((Object)"type") && ObjectUtil.isNotEmpty((Object)jsonObject.get((Object)"type"))) {
                Class targetClass = AopProxyUtils.ultimateTargetClass((Object)MessageFactory.getInvokeStrategy(jsonObject.getStr((Object)"type")));
                Class fieldClass = ClassUtil.getTypeArgument((Class)targetClass);
                Class<Message> messageClass = fieldClass.asSubclass(Message.class);
                Message messageObj = (Message)BeanUtil.toBean((Object)jsonObject, messageClass);
                MessageFactory.getInvokeStrategy(jsonObject.getStr((Object)"type")).execute(session, messageObj);
                return;
            }
            SysDefaultRequest sysDefaultRequest = SysDefaultRequest.builder().content((String)textMessage.getPayload()).build();
            MessageFactory.getInvokeStrategy(MessageType.SYS_DEFAULT_REQUEST.name()).execute(session, sysDefaultRequest);
        }
        catch (Throwable throwable) {
            log.info("[onMessage][session({}) message({}) \u53d1\u751f\u5f02\u5e38]", (Object)session, (Object)throwable);
        }
    }

    public void afterConnectionClosed(WebSocketSession session, CloseStatus status) throws Exception {
        log.info("[afterConnectionClosed][session({}) \u8fde\u63a5\u5173\u95ed\u3002\u5173\u95ed\u539f\u56e0\u662f({})}]", (Object)session, (Object)status);
        Object userName = session.getAttributes().get("userName");
        if (ObjectUtil.isNotEmpty(userName)) {
            UserJoinNoticeRequest request = UserJoinNoticeRequest.builder().userName(userName.toString()).message(StrUtil.format((CharSequence)"{}\u7528\u6237\u79bb\u7ebf", (Object[])new Object[]{userName})).build();
            WebSocketUtil.broadcastWithoutSelf(WebSocketResponseEnum.OFFLINE_USER, request, userName.toString());
        }
        WebSocketUtil.removeSession(session);
    }

    public void handleTransportError(WebSocketSession session, Throwable exception) throws Exception {
        log.info("[handleTransportError][session({}) \u53d1\u751f\u5f02\u5e38]", (Object)session, (Object)exception);
    }
}

