package cn.allbs.websocket.handler;

import cn.allbs.websocket.behavior.SysDefaultRequest;
import cn.allbs.websocket.message.MessageFactory;
import lombok.extern.slf4j.Slf4j;
import org.springframework.beans.factory.InitializingBean;
import org.springframework.web.socket.WebSocketSession;

import static cn.allbs.websocket.enums.MessageType.SYS_DEFAULT_REQUEST;

/**
 * @author ChenQi
 */
@Slf4j
public abstract class SysDefaultHandler implements MessageHandler<SysDefaultRequest>, InitializingBean {

    @Override
    public void execute(WebSocketSession session, SysDefaultRequest message) {
        log.info("接收消息内容为:" + message);
    }

    @Override
    public void afterPropertiesSet() {
        MessageFactory.register(SYS_DEFAULT_REQUEST.name(), this);
    }
}
